/*
 * Decompiled with CFR 0.152.
 */
package dev.ethancao.antixray.config;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public boolean isPureOreMiningEnabled() {
        return this.config.getBoolean("detection.pure-ore-mining.enabled", true);
    }

    public int getPureOreMiningValuableOresThreshold() {
        return this.config.getInt("detection.pure-ore-mining.valuable-ores-threshold", 5);
    }

    public int getPureOreMiningStoneThreshold() {
        return this.config.getInt("detection.pure-ore-mining.stone-threshold", 20);
    }

    public int getPureOreMiningSuspicionPoints() {
        return this.config.getInt("detection.pure-ore-mining.suspicion-points", 20);
    }

    public boolean isLowStoneMiningEnabled() {
        return this.config.getBoolean("detection.low-stone-mining.enabled", true);
    }

    public int getLowStoneMiningValuableOresThreshold() {
        return this.config.getInt("detection.low-stone-mining.valuable-ores-threshold", 8);
    }

    public int getLowStoneMiningStoneThreshold() {
        return this.config.getInt("detection.low-stone-mining.stone-threshold", 50);
    }

    public int getLowStoneMiningSuspicionPoints() {
        return this.config.getInt("detection.low-stone-mining.suspicion-points", 15);
    }

    public boolean isHighRatioEnabled() {
        return this.config.getBoolean("detection.high-ratio.enabled", true);
    }

    public int getHighRatioStoneBaseline() {
        return this.config.getInt("detection.high-ratio.stone-baseline", 50);
    }

    public double getHighRatioDiamondVeryHigh() {
        return this.config.getDouble("detection.high-ratio.diamond-ratio-very-high", 0.05);
    }

    public double getHighRatioDiamondHigh() {
        return this.config.getDouble("detection.high-ratio.diamond-ratio-high", 0.02);
    }

    public int getHighRatioSuspicionPointsVeryHigh() {
        return this.config.getInt("detection.high-ratio.suspicion-points-very-high", 10);
    }

    public int getHighRatioSuspicionPointsHigh() {
        return this.config.getInt("detection.high-ratio.suspicion-points-high", 5);
    }

    public boolean isConsoleLoggingEnabled() {
        return this.config.getBoolean("logging.console.enabled", true);
    }

    public boolean isJsonLoggingEnabled() {
        return this.config.getBoolean("logging.json-file.enabled", true);
    }

    public String getJsonLogFilePath() {
        return this.config.getString("logging.json-file.file-path", "logs/antixray.jsonl");
    }

    public boolean isDiamondValuable() {
        return this.config.getBoolean("valuable-ores.diamond", true);
    }

    public boolean isEmeraldValuable() {
        return this.config.getBoolean("valuable-ores.emerald", true);
    }

    public boolean isGoldValuable() {
        return this.config.getBoolean("valuable-ores.gold", true);
    }

    public int getManualFlagSuspicionPoints() {
        return this.config.getInt("manual-flags.suspicion-points-per-flag", 15);
    }
}

