/*
 * Decompiled with CFR 0.152.
 */
package dev.ethancao.antixray;

import dev.ethancao.antixray.config.ConfigManager;
import dev.ethancao.antixray.logging.JsonLogger;
import dev.ethancao.antixray.logging.XrayEvent;
import dev.ethancao.antixray.tracking.MiningStats;
import dev.ethancao.antixray.tracking.PlayerDataManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Sentinel
extends JavaPlugin
implements Listener {
    private PlayerDataManager dataManager;
    private JsonLogger jsonLogger;
    private ConfigManager configManager;

    public void onEnable() {
        this.getLogger().info("Sentinel Anti-Xray plugin enabled!");
        this.configManager = new ConfigManager(this);
        this.getLogger().info("Configuration loaded!");
        this.dataManager = new PlayerDataManager();
        this.jsonLogger = new JsonLogger(this.getDataFolder(), this.getLogger());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Mining tracker and JSON logging initialized!");
        this.getLogger().info("Logs will be written to: " + this.jsonLogger.getLogFilePath());
    }

    public void onDisable() {
        this.getLogger().info("Sentinel Anti-Xray plugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("sentinel")) {
            String subCommand;
            if (!sender.hasPermission("sentinel.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            if (args.length == 0) {
                this.sendUsageMessage(sender);
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "stats": {
                    return this.handleStatsCommand(sender, args);
                }
                case "reset": {
                    return this.handleResetCommand(sender, args);
                }
                case "flag": {
                    return this.handleFlagCommand(sender, args);
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand: " + args[0]);
            this.sendUsageMessage(sender);
            return true;
        }
        return false;
    }

    private void sendUsageMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Sentinel Anti-Xray ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sentinel stats <player>" + String.valueOf(ChatColor.GRAY) + " - View mining statistics");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sentinel reset <player>" + String.valueOf(ChatColor.GRAY) + " - Reset player statistics");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sentinel flag <player>" + String.valueOf(ChatColor.GRAY) + " - Manually flag player");
    }

    private boolean handleStatsCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sentinel stats <player>");
            return true;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        UUID targetUuid = null;
        String displayName = targetName;
        if (target != null) {
            targetUuid = target.getUniqueId();
            displayName = target.getName();
        } else {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
            if (offlinePlayer.hasPlayedBefore()) {
                targetUuid = offlinePlayer.getUniqueId();
                displayName = offlinePlayer.getName();
            }
        }
        if (targetUuid == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found: " + targetName);
            return true;
        }
        MiningStats stats = this.dataManager.getStats(targetUuid);
        if (stats == null || stats.getTotalStoneBlocks() == 0 && stats.getTotalOresMined() == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No mining data for " + displayName);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Mining Stats: " + displayName + " ===");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Ores Mined:");
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Diamonds: " + String.valueOf(ChatColor.AQUA) + stats.getDiamondsMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Emeralds: " + String.valueOf(ChatColor.GREEN) + stats.getEmeraldsMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Iron: " + String.valueOf(ChatColor.GRAY) + stats.getIronMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Gold: " + String.valueOf(ChatColor.GOLD) + stats.getGoldMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Coal: " + String.valueOf(ChatColor.DARK_GRAY) + stats.getCoalMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Lapis: " + String.valueOf(ChatColor.BLUE) + stats.getLapisMined());
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Redstone: " + String.valueOf(ChatColor.RED) + stats.getRedstoneMined());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Stone Blocks: " + String.valueOf(ChatColor.WHITE) + stats.getTotalStoneBlocks());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Total Ores: " + String.valueOf(ChatColor.WHITE) + stats.getTotalOresMined());
        double oreRatio = stats.getOreToStoneRatio();
        double diamondRatio = stats.getDiamondToStoneRatio();
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Ore/Stone Ratio: " + String.valueOf(ChatColor.WHITE) + String.format("%.4f", oreRatio));
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Diamond/Stone Ratio: " + String.valueOf(ChatColor.WHITE) + String.format("%.4f", diamondRatio));
        int suspicionScore = stats.getSuspicionScore();
        ChatColor scoreColor = suspicionScore >= 20 ? ChatColor.RED : (suspicionScore >= 10 ? ChatColor.YELLOW : ChatColor.GREEN);
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Suspicion Score: " + String.valueOf(scoreColor) + suspicionScore);
        if (stats.getManualFlags() > 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Manual Flags: " + stats.getManualFlags());
        }
        return true;
    }

    private boolean handleResetCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sentinel reset <player>");
            return true;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        UUID targetUuid = null;
        String displayName = targetName;
        if (target != null) {
            targetUuid = target.getUniqueId();
            displayName = target.getName();
        } else {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
            if (offlinePlayer.hasPlayedBefore()) {
                targetUuid = offlinePlayer.getUniqueId();
                displayName = offlinePlayer.getName();
            }
        }
        if (targetUuid == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found: " + targetName);
            return true;
        }
        if (!this.dataManager.hasStats(targetUuid)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No data to reset for " + displayName);
            return true;
        }
        this.dataManager.resetStats(targetUuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reset mining statistics for " + displayName);
        this.getLogger().info(sender.getName() + " reset stats for " + displayName);
        return true;
    }

    private boolean handleFlagCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sentinel flag <player>");
            return true;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player must be online: " + targetName);
            return true;
        }
        MiningStats stats = this.dataManager.getOrCreateStats(target.getUniqueId(), target.getName());
        stats.addManualFlag();
        stats.addSuspicionPoints(this.configManager.getManualFlagSuspicionPoints());
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Manually flagged " + target.getName() + " (Total flags: " + stats.getManualFlags() + ")");
        this.getLogger().warning(sender.getName() + " manually flagged " + target.getName() + " for suspicious activity");
        return true;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (player.isOp() || player.hasPermission("sentinel.admin")) {
            return;
        }
        Material blockType = event.getBlock().getType();
        MiningStats stats = this.dataManager.getOrCreateStats(player.getUniqueId(), player.getName());
        switch (blockType) {
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                stats.incrementDiamonds();
                this.checkSuspiciousActivity(player, stats, "DIAMOND");
                break;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                stats.incrementIron();
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: {
                stats.incrementGold();
                break;
            }
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: {
                stats.incrementEmeralds();
                this.checkSuspiciousActivity(player, stats, "EMERALD");
                break;
            }
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: {
                stats.incrementLapis();
                break;
            }
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: {
                stats.incrementRedstone();
                break;
            }
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: {
                stats.incrementCoal();
                break;
            }
            case STONE: 
            case COBBLESTONE: 
            case ANDESITE: 
            case DIORITE: 
            case GRANITE: 
            case TUFF: {
                stats.incrementStone();
                break;
            }
            case DEEPSLATE: 
            case COBBLED_DEEPSLATE: {
                stats.incrementDeepslate();
                break;
            }
        }
    }

    private void checkSuspiciousActivity(Player player, MiningStats stats, String oreType) {
        int totalStone = stats.getTotalStoneBlocks();
        int valuableOres = 0;
        if (this.configManager.isDiamondValuable()) {
            valuableOres += stats.getDiamondsMined();
        }
        if (this.configManager.isEmeraldValuable()) {
            valuableOres += stats.getEmeraldsMined();
        }
        if (this.configManager.isGoldValuable()) {
            valuableOres += stats.getGoldMined();
        }
        double diamondRatio = stats.getDiamondToStoneRatio();
        boolean suspicious = false;
        String reason = "";
        int suspicionPoints = 0;
        if (this.configManager.isPureOreMiningEnabled() && valuableOres >= this.configManager.getPureOreMiningValuableOresThreshold() && totalStone < this.configManager.getPureOreMiningStoneThreshold()) {
            suspicious = true;
            reason = String.format("Pure ore mining detected: %d valuable ores with only %d stone (likely xray)", valuableOres, totalStone);
            suspicionPoints = this.configManager.getPureOreMiningSuspicionPoints();
        } else if (this.configManager.isLowStoneMiningEnabled() && valuableOres >= this.configManager.getLowStoneMiningValuableOresThreshold() && totalStone < this.configManager.getLowStoneMiningStoneThreshold()) {
            suspicious = true;
            reason = String.format("Very low stone mining: %d valuable ores with only %d stone", valuableOres, totalStone);
            suspicionPoints = this.configManager.getLowStoneMiningSuspicionPoints();
        } else if (this.configManager.isHighRatioEnabled() && totalStone >= this.configManager.getHighRatioStoneBaseline()) {
            if (diamondRatio > this.configManager.getHighRatioDiamondVeryHigh()) {
                suspicious = true;
                reason = String.format("Very high diamond ratio: %.3f (diamonds: %d, stone: %d)", diamondRatio, stats.getDiamondsMined(), totalStone);
                suspicionPoints = this.configManager.getHighRatioSuspicionPointsVeryHigh();
            } else if (diamondRatio > this.configManager.getHighRatioDiamondHigh()) {
                suspicious = true;
                reason = String.format("High diamond ratio: %.3f (diamonds: %d, stone: %d)", diamondRatio, stats.getDiamondsMined(), totalStone);
                suspicionPoints = this.configManager.getHighRatioSuspicionPointsHigh();
            }
        }
        if (suspicious) {
            stats.addSuspicionPoints(suspicionPoints);
            if (this.configManager.isConsoleLoggingEnabled()) {
                this.getLogger().warning(String.format("[SUSPICIOUS] %s mined %s - %s (Score: %d, +%d points)", player.getName(), oreType, reason, stats.getSuspicionScore(), suspicionPoints));
            }
            if (this.configManager.isJsonLoggingEnabled()) {
                String detectionType = suspicionPoints == this.configManager.getPureOreMiningSuspicionPoints() ? "pure_ore_mining" : (suspicionPoints == this.configManager.getLowStoneMiningSuspicionPoints() ? "low_stone_mining" : "high_ratio");
                XrayEvent event = new XrayEvent(this.jsonLogger.getCurrentTimestamp(), player.getName(), player.getUniqueId().toString(), oreType.toLowerCase() + "_mine", "UNKNOWN", player.getLocation(), stats.getTotalStoneBlocks(), stats.getDiamondsMined(), stats.getTotalOresMined(), stats.getDiamondToStoneRatio(), stats.getSuspicionScore(), detectionType, reason);
                this.jsonLogger.logEvent(event);
            }
        }
    }
}

