/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EntryLevelFlagHandler
extends Handler {
    private final Plugin plugin;
    private final ConcurrentHashMap<String, PlaceholderCacheEntry> placeholderCache = new ConcurrentHashMap();
    private static final long CACHE_DURATION_MS = TimeUnit.SECONDS.toMillis(30L);

    public static final Factory FACTORY(Plugin plugin) {
        return new Factory(plugin);
    }

    protected EntryLevelFlagHandler(Plugin plugin, Session session) {
        super(session);
        this.plugin = plugin;
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        String maxLevelValue;
        if (this.getSession().getManager().hasBypass(player, (World)to.getExtent())) {
            return true;
        }
        String minLevelValue = (String)toSet.queryValue((RegionAssociable)player, Flags.ENTRY_MIN_LEVEL);
        if (minLevelValue != null && !minLevelValue.isEmpty()) {
            ParsedFlagValue parsed = this.parseFlagValue(minLevelValue);
            if (parsed == null) {
                return true;
            }
            Integer playerValue = this.getPlayerValue(player, parsed.source);
            if (playerValue == null) {
                return true;
            }
            if (playerValue < parsed.threshold) {
                this.sendDeniedMessage(((BukkitPlayer)player).getPlayer(), "entry-min-level", parsed.threshold, playerValue);
                return false;
            }
        }
        if ((maxLevelValue = (String)toSet.queryValue((RegionAssociable)player, Flags.ENTRY_MAX_LEVEL)) != null && !maxLevelValue.isEmpty()) {
            ParsedFlagValue parsed = this.parseFlagValue(maxLevelValue);
            if (parsed == null) {
                return true;
            }
            Integer playerValue = this.getPlayerValue(player, parsed.source);
            if (playerValue == null) {
                return true;
            }
            if (playerValue > parsed.threshold) {
                this.sendDeniedMessage(((BukkitPlayer)player).getPlayer(), "entry-max-level", parsed.threshold, playerValue);
                return false;
            }
        }
        return true;
    }

    private ParsedFlagValue parseFlagValue(String flagValue) {
        int threshold;
        if (flagValue == null || flagValue.trim().isEmpty()) {
            return null;
        }
        String trimmed = flagValue.trim();
        String[] parts = trimmed.split("\\s+", 2);
        if (parts.length != 2) {
            return null;
        }
        try {
            threshold = Integer.parseInt(parts[0].trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        String source = parts[1].trim();
        return new ParsedFlagValue(threshold, source);
    }

    private Integer getPlayerValue(LocalPlayer localPlayer, String source) {
        if (source == null || source.trim().isEmpty()) {
            return null;
        }
        String trimmed = source.trim();
        if (trimmed.equalsIgnoreCase("XP")) {
            Player bukkitPlayer = ((BukkitPlayer)localPlayer).getPlayer();
            if (!bukkitPlayer.isOnline()) {
                return null;
            }
            return bukkitPlayer.getLevel();
        }
        if (trimmed.startsWith("%") && trimmed.endsWith("%") && trimmed.length() > 2) {
            return this.getPlayerPlaceholderValue(localPlayer, trimmed);
        }
        return null;
    }

    private Integer getPlayerPlaceholderValue(LocalPlayer localPlayer, String placeholder) {
        if (placeholder == null || placeholder.trim().isEmpty()) {
            return null;
        }
        Player bukkitPlayer = ((BukkitPlayer)localPlayer).getPlayer();
        if (!bukkitPlayer.isOnline()) {
            return null;
        }
        String trimmed = placeholder.trim();
        if (!trimmed.startsWith("%") || !trimmed.endsWith("%") || trimmed.length() <= 2) {
            return null;
        }
        String cacheKey = bukkitPlayer.getUniqueId().toString() + trimmed;
        PlaceholderCacheEntry cached = this.placeholderCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return cached.getValue();
        }
        if (!this.isPlaceholderAPIAvailable()) {
            return null;
        }
        String placeholderValue = this.getPlaceholderValue(bukkitPlayer, trimmed);
        Integer parsedValue = this.parseInteger(placeholderValue);
        if (parsedValue != null) {
            this.placeholderCache.put(cacheKey, new PlaceholderCacheEntry(parsedValue, System.currentTimeMillis()));
        }
        return parsedValue;
    }

    private boolean isPlaceholderAPIAvailable() {
        return this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private String getPlaceholderValue(Player player, String placeholder) {
        if (!this.isPlaceholderAPIAvailable()) {
            return "";
        }
        try {
            Class<?> placeholderAPIClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            Method setPlaceholdersMethod = placeholderAPIClass.getMethod("setPlaceholders", Player.class, String.class);
            return (String)setPlaceholdersMethod.invoke(null, player, placeholder);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Integer parseInteger(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            String numericOnly = value.trim().replaceAll("[^0-9-]", "");
            if (!numericOnly.isEmpty() && !numericOnly.equals("-")) {
                return Integer.parseInt(numericOnly);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private void sendDeniedMessage(Player player, String flagType, Integer requiredLevel, Integer playerLevel) {
        String[] replacements;
        String messageKey;
        if (player == null || !player.isOnline()) {
            return;
        }
        if ("entry-min-level".equals(flagType)) {
            messageKey = "entry-min-level-denied";
            replacements = new String[]{"required", String.valueOf(requiredLevel), "current", playerLevel != null ? String.valueOf(playerLevel) : "?"};
        } else {
            messageKey = "entry-max-level-denied";
            replacements = new String[]{"required", String.valueOf(requiredLevel), "current", playerLevel != null ? String.valueOf(playerLevel) : "?"};
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)player, task -> {
            if (player.isOnline()) {
                this.sendMessageWithCooldown(player, messageKey, replacements);
            }
        });
    }

    private void sendMessageWithCooldown(Player player, String key, String ... replacements) {
        block6: {
            try {
                Class<?> messagesClass = Class.forName("dev.tins.worldguardextraflagsplus.Messages");
                Method sendMessageMethod = messagesClass.getMethod("sendMessageWithCooldown", Player.class, String.class, String[].class);
                sendMessageMethod.invoke(null, player, key, replacements);
            }
            catch (Exception e) {
                String message;
                if ("entry-min-level-denied".equals(key)) {
                    String required = replacements.length > 1 ? replacements[1] : "?";
                    String current = replacements.length > 3 ? replacements[3] : "?";
                    message = String.valueOf(ChatColor.RED) + "Your level (" + current + ") is low to enter this area. " + String.valueOf(ChatColor.GRAY) + "Min: " + required;
                } else if ("entry-max-level-denied".equals(key)) {
                    String required = replacements.length > 1 ? replacements[1] : "?";
                    String current = replacements.length > 3 ? replacements[3] : "?";
                    message = String.valueOf(ChatColor.RED) + "Your level (" + current + ") is so high to enter this area. " + String.valueOf(ChatColor.GRAY) + "Max: " + required;
                } else {
                    message = String.valueOf(ChatColor.RED) + "Message not found: " + key;
                }
                if (!player.isOnline()) break block6;
                player.sendMessage(message);
            }
        }
    }

    public static class Factory
    extends Handler.Factory<EntryLevelFlagHandler> {
        private final Plugin plugin;

        public Factory(Plugin plugin) {
            this.plugin = plugin;
        }

        public EntryLevelFlagHandler create(Session session) {
            return new EntryLevelFlagHandler(this.plugin, session);
        }
    }

    private static class ParsedFlagValue {
        final int threshold;
        final String source;

        ParsedFlagValue(int threshold, String source) {
            this.threshold = threshold;
            this.source = source;
        }
    }

    private static class PlaceholderCacheEntry {
        private final Integer value;
        private final long timestamp;

        public PlaceholderCacheEntry(Integer value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        public Integer getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > CACHE_DURATION_MS;
        }
    }
}

