/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import dev.tins.worldguardextraflagsplus.WorldGuardExtraFlagsPlusPlugin;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import lombok.Generated;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;

public class WorldListener
implements Listener {
    private final WorldGuardExtraFlagsPlusPlugin plugin;
    private final RegionContainer regionContainer;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoadEvent(WorldLoadEvent event) {
        World world = event.getWorld();
        this.plugin.doUnloadChunkFlagCheck(world);
    }

    @EventHandler(ignoreCancelled=true)
    public void onChunkUnloadEvent(ChunkUnloadEvent event) {
        World world = event.getWorld();
        Chunk chunk = event.getChunk();
        this.doUnloadChunkFlagCheck(world, chunk);
    }

    private void doUnloadChunkFlagCheck(World world, Chunk chunk) {
        RegionManager regionManager = this.regionContainer.get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return;
        }
        for (ProtectedRegion region : regionManager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("UnloadChunkFlagTester", BlockVector3.at((int)(chunk.getX() * 16), (int)world.getMinHeight(), (int)(chunk.getZ() * 16)), BlockVector3.at((int)(chunk.getX() * 16 + 15), (int)world.getMaxHeight(), (int)(chunk.getZ() * 16 + 15))))) {
            if (region.getFlag((Flag)Flags.CHUNK_UNLOAD) != StateFlag.State.DENY) continue;
            chunk.addPluginChunkTicket((Plugin)this.plugin);
        }
    }

    @Generated
    public WorldListener(WorldGuardExtraFlagsPlusPlugin plugin, RegionContainer regionContainer) {
        this.plugin = plugin;
        this.regionContainer = regionContainer;
    }
}

