/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.WorldGuardExtraFlagsPlusPlugin;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import dev.tins.worldguardextraflagsplus.wg.handlers.FlyFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GiveEffectsFlagHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class PlayerListener
implements Listener {
    private final WorldGuardExtraFlagsPlusPlugin plugin;
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleportEvent(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        player.removeMetadata("WGEFP: TLP", (Plugin)this.plugin);
    }

    @EventHandler
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        Boolean keepExp;
        Player player = event.getEntity();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Boolean keepInventory = (Boolean)regions.queryValue((RegionAssociable)localPlayer, (Flag)Flags.KEEP_INVENTORY);
        if (keepInventory != null) {
            event.setKeepInventory(keepInventory.booleanValue());
            if (keepInventory.booleanValue()) {
                event.getDrops().clear();
            }
        }
        if ((keepExp = (Boolean)regions.queryValue((RegionAssociable)localPlayer, (Flag)Flags.KEEP_EXP)) != null) {
            event.setKeepLevel(keepExp.booleanValue());
            if (keepExp.booleanValue()) {
                event.setDroppedExp(0);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        String suffix;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        String prefix = (String)regions.queryValue((RegionAssociable)localPlayer, (Flag)Flags.CHAT_PREFIX);
        if (prefix != null) {
            prefix = this.processPlaceholders(player, prefix);
            event.setFormat(prefix + event.getFormat());
        }
        if ((suffix = (String)regions.queryValue((RegionAssociable)localPlayer, (Flag)Flags.CHAT_SUFFIX)) != null) {
            suffix = this.processPlaceholders(player, suffix);
            event.setFormat(event.getFormat() + suffix);
        }
    }

    private String processPlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (!this.isPlaceholderAPIAvailable()) {
            return text;
        }
        try {
            Class<?> placeholderAPIClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            Method setPlaceholdersMethod = placeholderAPIClass.getMethod("setPlaceholders", Player.class, String.class);
            return (String)setPlaceholdersMethod.invoke(null, player, text);
        }
        catch (Exception e) {
            return text;
        }
    }

    private boolean isPlaceholderAPIAvailable() {
        return this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        com.sk89q.worldedit.util.Location respawnLocation = (com.sk89q.worldedit.util.Location)this.regionContainer.createQuery().queryValue(localPlayer.getLocation(), localPlayer, (Flag)Flags.RESPAWN_LOCATION);
        if (respawnLocation != null) {
            event.setRespawnLocation(BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)respawnLocation));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerItemConsumeEvent(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemMeta itemMeta = event.getItem().getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            if (potionMeta.getBasePotionType() != null) {
                effects.addAll(potionMeta.getBasePotionType().getPotionEffects());
            }
            effects.addAll(potionMeta.getCustomEffects());
            ((GiveEffectsFlagHandler)this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player)).getHandler(GiveEffectsFlagHandler.class)).drinkPotion(player, effects);
        } else {
            Material material = event.getItem().getType();
            if (material == Material.MILK_BUCKET) {
                ((GiveEffectsFlagHandler)this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player)).getHandler(GiveEffectsFlagHandler.class)).drinkMilk(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerGameModeChangeEvent(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        Session wgSession = this.sessionManager.getIfPresent(this.worldGuardPlugin.wrapPlayer(player));
        if (wgSession != null) {
            Boolean value = ((FlyFlagHandler)wgSession.getHandler(FlyFlagHandler.class)).getCurrentValue();
            if (value != null) {
                WorldGuardUtils.getScheduler().runAtEntity((Entity)player, wrappedTask -> this.checkFlyStatus(player, player.getAllowFlight()));
            }
        } else {
            WorldGuardUtils.getScheduler().runAtEntity((Entity)player, wrappedTask -> this.checkFlyStatus(player, null));
        }
    }

    private void checkFlyStatus(Player player, Boolean originalValueOverwrite) {
        FlyFlagHandler flyFlagHandler = (FlyFlagHandler)this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player)).getHandler(FlyFlagHandler.class);
        Boolean currentValue = flyFlagHandler.getCurrentValue();
        if (currentValue != null) {
            player.setAllowFlight(currentValue.booleanValue());
        }
        if (originalValueOverwrite != null) {
            flyFlagHandler.setOriginalFly(originalValueOverwrite);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerItemDamageEvent(PlayerItemDamageEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.regionContainer.createQuery().queryState(localPlayer.getLocation(), localPlayer, new StateFlag[]{Flags.ITEM_DURABILITY}) == StateFlag.State.DENY) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSpawnLocationEvent(PlayerSpawnLocationEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location location = (com.sk89q.worldedit.util.Location)this.regionContainer.createQuery().queryValue(BukkitAdapter.adapt((Location)event.getSpawnLocation()), localPlayer, (Flag)Flags.JOIN_LOCATION);
        if (location != null) {
            event.setSpawnLocation(BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)location));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Boolean value = ((FlyFlagHandler)this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player)).getHandler(FlyFlagHandler.class)).getCurrentValue();
        if (value != null) {
            WorldGuardUtils.getScheduler().runAtEntity((Entity)player, wrappedTask -> player.setAllowFlight(value.booleanValue()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Boolean value = ((FlyFlagHandler)this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player)).getHandler(FlyFlagHandler.class)).getCurrentValue();
        if (value != null) {
            WorldGuardUtils.getScheduler().runAtEntity((Entity)player, wrappedTask -> player.setAllowFlight(value.booleanValue()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        Material itemType = event.getItemDrop().getItemStack().getType();
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)player.getLocation());
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(location);
        Set denySet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.DENY_ITEM_DROPS);
        if (denySet != null && !denySet.isEmpty() && denySet.contains(itemType)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        Material itemType = event.getItem().getItemStack().getType();
        com.sk89q.worldedit.util.Location itemLocation = BukkitAdapter.adapt((Location)event.getItem().getLocation());
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(itemLocation);
        Set denySet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.DENY_ITEM_PICKUP);
        if (denySet != null && !denySet.isEmpty() && denySet.contains(itemType)) {
            event.setCancelled(true);
        }
    }

    @Generated
    public PlayerListener(WorldGuardExtraFlagsPlusPlugin plugin, WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.plugin = plugin;
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }
}

