/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.Config;
import dev.tins.worldguardextraflagsplus.Messages;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.helpers.BlockableItemFlag;
import dev.tins.worldguardextraflagsplus.flags.helpers.ForcedStateFlag;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EntityListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;
    private static final Set<String> BLOCKABLE_ITEMS = BlockableItemFlag.getBlockableItems();
    private static final Map<Material, String> WORKBENCH_TYPE_MAP = new HashMap<Material, String>();
    private static final Map<Material, String> WORKBENCH_DISPLAY_NAMES = new HashMap<Material, String>();

    @EventHandler(ignoreCancelled=true)
    public void onPortalCreateEvent(PortalCreateEvent event) {
        LocalPlayer localPlayer;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            localPlayer = this.worldGuardPlugin.wrapPlayer(player);
            if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
                return;
            }
        } else {
            localPlayer = null;
        }
        for (BlockState block : event.getBlocks()) {
            if (this.regionContainer.createQuery().queryState(BukkitAdapter.adapt((Location)block.getLocation()), localPlayer, new StateFlag[]{Flags.NETHER_PORTALS}) != StateFlag.State.DENY) continue;
            event.setCancelled(true);
            break;
        }
    }

    private boolean isBlocked(LocalPlayer localPlayer, Material material) {
        String name = material.name();
        if (!BLOCKABLE_ITEMS.contains(name)) {
            return false;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set set = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_COMPLETELY);
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String item : set) {
            if (item == null || !item.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void sendBlocked(Player player, String itemName) {
        Messages.sendMessageWithCooldown(player, "permit-completely-blocked", "item", itemName);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onItemInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material mat = item.getType();
        if (mat == Material.AIR) {
            return;
        }
        if (this.isBlocked(localPlayer, mat)) {
            Action action;
            if (mat == Material.TRIDENT && item.containsEnchantment(Enchantment.RIPTIDE) && ((action = event.getAction()) == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK)) {
                event.setCancelled(true);
                this.sendBlocked(player, mat.name());
                return;
            }
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Material mat;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        Material mat;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectile(ProjectileLaunchEvent event) {
        Material mat;
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onPlayerRiptide(PlayerRiptideEvent event) {
        Cancellable cancellable;
        if (event instanceof Cancellable && (cancellable = (Cancellable)event).isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material mat = item.getType();
        if (mat == Material.TRIDENT && this.isBlocked(localPlayer, mat)) {
            if (event instanceof Cancellable) {
                Cancellable cancellable2 = (Cancellable)event;
                cancellable2.setCancelled(true);
            }
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityResurrectEvent(EntityResurrectEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        Material totemMaterial = Material.TOTEM_OF_UNDYING;
        if (mainHand != null && mainHand.getType() == totemMaterial && this.isBlocked(localPlayer, totemMaterial)) {
            event.setCancelled(true);
            this.sendBlocked(player, totemMaterial.name());
            return;
        }
        if (offHand != null && offHand.getType() == totemMaterial && this.isBlocked(localPlayer, totemMaterial)) {
            event.setCancelled(true);
            this.sendBlocked(player, totemMaterial.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
            if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
                return;
            }
            ForcedStateFlag.ForcedState state = (ForcedStateFlag.ForcedState)((Object)this.regionContainer.createQuery().queryValue(localPlayer.getLocation(), localPlayer, (Flag)Flags.GLIDE));
            switch (state) {
                case ALLOW: {
                    break;
                }
                case DENY: {
                    if (!event.isGliding()) {
                        return;
                    }
                    event.setCancelled(true);
                    WorldGuardUtils.getScheduler().runAtEntity((Entity)player, task -> {
                        Vector velocity = player.getVelocity();
                        velocity.setY(Math.min(velocity.getY(), -0.5));
                        player.setVelocity(velocity);
                    });
                    break;
                }
                case FORCE: {
                    if (event.isGliding()) {
                        return;
                    }
                    event.setCancelled(true);
                }
            }
        }
    }

    private boolean isWorkbenchBlocked(LocalPlayer localPlayer, Material blockMaterial) {
        String workbenchType = WORKBENCH_TYPE_MAP.get(blockMaterial);
        if (workbenchType == null) {
            return false;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set flagSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_WORKBENCHES);
        if (flagSet == null || flagSet.isEmpty()) {
            return false;
        }
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase("CLEAR")) continue;
            return false;
        }
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase(workbenchType)) continue;
            return true;
        }
        boolean hasAll = false;
        boolean allIncludesEnder = Config.isPermitAllIncludesEnderchest();
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase("ALL")) continue;
            hasAll = true;
            break;
        }
        if (hasAll) {
            if (workbenchType.equals("ENDER")) {
                return allIncludesEnder;
            }
            return true;
        }
        return false;
    }

    private String getWorkbenchDisplayName(Material blockMaterial) {
        return WORKBENCH_DISPLAY_NAMES.getOrDefault(blockMaterial, blockMaterial.name());
    }

    private void sendWorkbenchBlocked(Player player, String workbenchName) {
        Messages.sendMessageWithCooldown(player, "permit-workbenches-blocked", "workbench", workbenchName);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onWorkbenchInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        Material blockMaterial = block.getType();
        if (this.isWorkbenchBlocked(localPlayer, blockMaterial)) {
            event.setCancelled(true);
            this.sendWorkbenchBlocked(player, this.getWorkbenchDisplayName(blockMaterial));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        if (event.getInventory().getType() != InventoryType.WORKBENCH) {
            return;
        }
        Player player = null;
        for (HumanEntity viewer : event.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            player = (Player)viewer;
            break;
        }
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set flagSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_WORKBENCHES);
        if (flagSet != null && !flagSet.isEmpty()) {
            boolean hasClear = false;
            for (String value : flagSet) {
                if (value == null || !value.equalsIgnoreCase("CLEAR")) continue;
                hasClear = true;
                break;
            }
            if (!hasClear) {
                boolean shouldBlock = false;
                for (String value : flagSet) {
                    if (value == null || !value.equalsIgnoreCase("ALL") && !value.equalsIgnoreCase("CRAFT")) continue;
                    shouldBlock = true;
                    break;
                }
                if (shouldBlock) {
                    event.getInventory().setResult(null);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set flagSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_WORKBENCHES);
        if (flagSet != null && !flagSet.isEmpty()) {
            boolean hasClear = false;
            for (String value : flagSet) {
                if (value == null || !value.equalsIgnoreCase("CLEAR")) continue;
                hasClear = true;
                break;
            }
            if (!hasClear) {
                boolean shouldBlock = false;
                for (String value : flagSet) {
                    if (value == null || !value.equalsIgnoreCase("ALL") && !value.equalsIgnoreCase("CRAFT")) continue;
                    shouldBlock = true;
                    break;
                }
                if (shouldBlock) {
                    event.setCancelled(true);
                    this.sendWorkbenchBlocked(player, "Crafting");
                }
            }
        }
    }

    @Generated
    public EntityListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }

    static {
        WORKBENCH_TYPE_MAP.put(Material.ANVIL, "ANVIL");
        WORKBENCH_TYPE_MAP.put(Material.CHIPPED_ANVIL, "ANVIL");
        WORKBENCH_TYPE_MAP.put(Material.DAMAGED_ANVIL, "ANVIL");
        WORKBENCH_DISPLAY_NAMES.put(Material.ANVIL, "Anvil");
        WORKBENCH_DISPLAY_NAMES.put(Material.CHIPPED_ANVIL, "Anvil");
        WORKBENCH_DISPLAY_NAMES.put(Material.DAMAGED_ANVIL, "Anvil");
        WORKBENCH_TYPE_MAP.put(Material.CARTOGRAPHY_TABLE, "CARTOGRAPHY");
        WORKBENCH_DISPLAY_NAMES.put(Material.CARTOGRAPHY_TABLE, "Cartography Table");
        WORKBENCH_TYPE_MAP.put(Material.CRAFTING_TABLE, "CRAFT");
        WORKBENCH_DISPLAY_NAMES.put(Material.CRAFTING_TABLE, "Crafting Table");
        WORKBENCH_TYPE_MAP.put(Material.ENDER_CHEST, "ENDER");
        WORKBENCH_DISPLAY_NAMES.put(Material.ENDER_CHEST, "Ender Chest");
        WORKBENCH_TYPE_MAP.put(Material.GRINDSTONE, "GRINDSTONE");
        WORKBENCH_DISPLAY_NAMES.put(Material.GRINDSTONE, "Grindstone");
        WORKBENCH_TYPE_MAP.put(Material.LOOM, "LOOM");
        WORKBENCH_DISPLAY_NAMES.put(Material.LOOM, "Loom");
        WORKBENCH_TYPE_MAP.put(Material.SMITHING_TABLE, "SMITHING");
        WORKBENCH_DISPLAY_NAMES.put(Material.SMITHING_TABLE, "Smithing Table");
        WORKBENCH_TYPE_MAP.put(Material.STONECUTTER, "STONECUTTER");
        WORKBENCH_DISPLAY_NAMES.put(Material.STONECUTTER, "Stonecutter");
    }
}

