/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.Config;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;

public class BlockListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;
    private static final Map<Material, String> WORKBENCH_TYPE_MAP = new HashMap<Material, String>();

    private boolean isWorkbenchPlacementBlocked(LocalPlayer localPlayer, Material blockMaterial, com.sk89q.worldedit.util.Location blockLocation) {
        if (!Config.isPermitWorkbenchBlockPlacementToo()) {
            return false;
        }
        String workbenchType = WORKBENCH_TYPE_MAP.get(blockMaterial);
        if (workbenchType == null) {
            return false;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set flagSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_WORKBENCHES);
        if (flagSet == null || flagSet.isEmpty()) {
            return false;
        }
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase("CLEAR")) continue;
            return false;
        }
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase(workbenchType)) continue;
            return true;
        }
        boolean hasAll = false;
        boolean allIncludesEnder = Config.isPermitAllIncludesEnderchest();
        for (String value : flagSet) {
            if (value == null || !value.equalsIgnoreCase("ALL")) continue;
            hasAll = true;
            break;
        }
        if (hasAll) {
            if (workbenchType.equals("ENDER")) {
                return allIncludesEnder;
            }
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onBlockPlaceEvent(PlaceBlockEvent event) {
        Event.Result originalResult = event.getResult();
        Object cause = event.getCause().getRootCause();
        if (!(cause instanceof Player)) {
            return;
        }
        Player player = (Player)cause;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        for (Block block : event.getBlocks()) {
            Material type = block.getType();
            if (type == Material.AIR) {
                type = event.getEffectiveMaterial();
            }
            com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)block.getLocation());
            ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(location);
            Set allowSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.ALLOW_BLOCK_PLACE);
            if (allowSet != null && !allowSet.isEmpty() && allowSet.contains(type)) {
                event.setResult(Event.Result.ALLOW);
                continue;
            }
            Set denySet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.DENY_BLOCK_PLACE);
            if (denySet != null && !denySet.isEmpty() && denySet.contains(type)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            if (this.isWorkbenchPlacementBlocked(localPlayer, type, location)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            event.setResult(originalResult);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onBlockBreakEvent(BreakBlockEvent event) {
        Event.Result originalResult = event.getResult();
        Object cause = event.getCause().getRootCause();
        if (!(cause instanceof Player)) {
            return;
        }
        Player player = (Player)cause;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        for (Block block : event.getBlocks()) {
            Material type = block.getType();
            com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)block.getLocation());
            ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(location);
            Set allowSet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.ALLOW_BLOCK_BREAK);
            if (allowSet != null && !allowSet.isEmpty() && allowSet.contains(type)) {
                event.setResult(Event.Result.ALLOW);
                continue;
            }
            Set denySet = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.DENY_BLOCK_BREAK);
            if (denySet != null && !denySet.isEmpty() && denySet.contains(type)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            event.setResult(originalResult);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityBlockFormEvent(EntityBlockFormEvent event) {
        BlockState newState = event.getNewState();
        if (newState.getType() == Material.FROSTED_ICE) {
            LocalPlayer localPlayer;
            com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)newState.getLocation());
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                localPlayer = this.worldGuardPlugin.wrapPlayer(player);
                if (this.sessionManager.hasBypass(localPlayer, (World)location.getExtent())) {
                    return;
                }
            } else {
                localPlayer = null;
            }
            if (this.regionContainer.createQuery().queryValue(location, localPlayer, (Flag)Flags.FROSTWALKER) == StateFlag.State.DENY) {
                event.setCancelled(true);
            }
        }
    }

    @Generated
    public BlockListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }

    static {
        WORKBENCH_TYPE_MAP.put(Material.ANVIL, "ANVIL");
        WORKBENCH_TYPE_MAP.put(Material.CHIPPED_ANVIL, "ANVIL");
        WORKBENCH_TYPE_MAP.put(Material.DAMAGED_ANVIL, "ANVIL");
        WORKBENCH_TYPE_MAP.put(Material.CARTOGRAPHY_TABLE, "CARTOGRAPHY");
        WORKBENCH_TYPE_MAP.put(Material.CRAFTING_TABLE, "CRAFT");
        WORKBENCH_TYPE_MAP.put(Material.ENDER_CHEST, "ENDER");
        WORKBENCH_TYPE_MAP.put(Material.GRINDSTONE, "GRINDSTONE");
        WORKBENCH_TYPE_MAP.put(Material.LOOM, "LOOM");
        WORKBENCH_TYPE_MAP.put(Material.SMITHING_TABLE, "SMITHING");
        WORKBENCH_TYPE_MAP.put(Material.STONECUTTER, "STONECUTTER");
    }
}

