/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import java.util.HashSet;
import java.util.Set;

public class PermitWorkbenchesFlag
extends Flag<String> {
    private static final Set<String> VALID_WORKBENCHES = new HashSet<String>();

    public PermitWorkbenchesFlag(String name) {
        super(name);
    }

    public Object marshal(String o) {
        return o;
    }

    public String parseInput(FlagContext context) throws InvalidFlagFormat {
        String input = context.getUserInput().trim();
        if (input.isEmpty()) {
            throw new InvalidFlagFormat("Workbench type cannot be empty");
        }
        String upperInput = input.toUpperCase();
        if (!VALID_WORKBENCHES.contains(upperInput)) {
            throw new InvalidFlagFormat("Invalid workbench type '" + input + "'. Valid types: " + String.join((CharSequence)", ", VALID_WORKBENCHES));
        }
        return upperInput;
    }

    public String unmarshal(Object o) {
        String workbench;
        if (o instanceof String && VALID_WORKBENCHES.contains(workbench = ((String)o).toUpperCase())) {
            return workbench;
        }
        return null;
    }

    public static Set<String> getValidWorkbenches() {
        return new HashSet<String>(VALID_WORKBENCHES);
    }

    static {
        VALID_WORKBENCHES.add("ALL");
        VALID_WORKBENCHES.add("CLEAR");
        VALID_WORKBENCHES.add("ANVIL");
        VALID_WORKBENCHES.add("CARTOGRAPHY");
        VALID_WORKBENCHES.add("CRAFT");
        VALID_WORKBENCHES.add("ENDER");
        VALID_WORKBENCHES.add("GRINDSTONE");
        VALID_WORKBENCHES.add("LOOM");
        VALID_WORKBENCHES.add("SMITHING");
        VALID_WORKBENCHES.add("STONECUTTER");
    }
}

