/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import java.util.Collection;

public class ForcedStateFlag
extends Flag<ForcedState> {
    public ForcedStateFlag(String name) {
        super(name);
    }

    public ForcedState getDefault() {
        return ForcedState.ALLOW;
    }

    public boolean hasConflictStrategy() {
        return true;
    }

    public ForcedState chooseValue(Collection<ForcedState> values) {
        ForcedState result = null;
        if (!values.isEmpty()) {
            for (ForcedState state : values) {
                if (state == ForcedState.DENY) {
                    return ForcedState.DENY;
                }
                if (state == ForcedState.FORCE) {
                    result = ForcedState.FORCE;
                    continue;
                }
                if (state != ForcedState.ALLOW || result != null) continue;
                result = ForcedState.ALLOW;
            }
        }
        return result;
    }

    public ForcedState parseInput(FlagContext context) throws InvalidFlagFormat {
        String input = context.getUserInput();
        if (input.equalsIgnoreCase("allow")) {
            return ForcedState.ALLOW;
        }
        if (input.equalsIgnoreCase("force")) {
            return ForcedState.FORCE;
        }
        if (input.equalsIgnoreCase("deny")) {
            return ForcedState.DENY;
        }
        if (input.equalsIgnoreCase("none")) {
            return null;
        }
        throw new InvalidFlagFormat("Expected none/allow/force/deny but got '" + input + "'");
    }

    public ForcedState unmarshal(Object o) {
        String str;
        switch (str = o.toString()) {
            case "ALLOW": {
                return ForcedState.ALLOW;
            }
            case "FORCE": {
                return ForcedState.FORCE;
            }
            case "DENY": {
                return ForcedState.DENY;
            }
        }
        return null;
    }

    public Object marshal(ForcedState o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static enum ForcedState {
        ALLOW,
        DENY,
        FORCE;

    }
}

