/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.google.common.collect.Sets;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.SetFlag;
import java.util.LinkedHashSet;
import java.util.Set;

public class CustomSetFlag<T>
extends SetFlag<T> {
    public CustomSetFlag(String name, Flag<T> subFlag) {
        super(name, subFlag);
    }

    public Set<T> parseInput(FlagContext context) throws InvalidFlagFormat {
        String input = context.getUserInput().trim();
        String lowerInput = input.toLowerCase();
        if (lowerInput.equals("clear")) {
            return Sets.newLinkedHashSet();
        }
        if (input.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet items = Sets.newLinkedHashSet();
        for (String str : input.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
            if ((str = str.trim()).startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            FlagContext copy = context.copyWith(null, str, null);
            items.add(this.getType().parseInput(copy));
        }
        return items;
    }

    public Set<T> unmarshal(Object o) {
        if (!(o instanceof Iterable)) {
            return null;
        }
        Iterable iterable = (Iterable)o;
        LinkedHashSet items = Sets.newLinkedHashSet();
        iterable.forEach(i -> {
            Object value = this.getType().unmarshal(i);
            if (value != null) {
                items.add(value);
            }
        });
        return items;
    }
}

