/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Messages {
    private static JavaPlugin plugin;
    private static FileConfiguration messages;
    private static File messagesFile;
    private static int messageCooldownSeconds;
    private static final ConcurrentHashMap<UUID, Long> messageCooldowns;

    public static void initialize(JavaPlugin plugin) {
        Messages.plugin = plugin;
        File worldGuardDataFolder = plugin.getServer().getPluginManager().getPlugin("WorldGuard").getDataFolder();
        messagesFile = new File(worldGuardDataFolder, "messages-wgefp.yml");
        if (!messagesFile.exists()) {
            Messages.saveDefaultMessages(worldGuardDataFolder);
        }
        Messages.reloadMessages();
    }

    private static void saveDefaultMessages(File worldGuardDataFolder) {
        try {
            int length;
            if (!worldGuardDataFolder.exists()) {
                worldGuardDataFolder.mkdirs();
            }
            if (messagesFile.exists()) {
                plugin.getLogger().info("messages-wgefp.yml already exists in WorldGuard folder, skipping default copy.");
                return;
            }
            InputStream defaultStream = plugin.getResource("messages-wgefp.yml");
            if (defaultStream == null) {
                plugin.getLogger().warning("Default messages-wgefp.yml not found in plugin resources!");
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(messagesFile);
            byte[] buffer = new byte[1024];
            while ((length = defaultStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            defaultStream.close();
            plugin.getLogger().info("Created messages-wgefp.yml in WorldGuard folder: " + messagesFile.getAbsolutePath());
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to save default messages-wgefp.yml", e);
        }
    }

    public static void reloadMessages() {
        try {
            messages = YamlConfiguration.loadConfiguration((File)messagesFile);
            InputStream defaultStream = plugin.getResource("messages-wgefp.yml");
            if (defaultStream != null) {
                InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                messages.setDefaults((Configuration)defaultConfig);
            }
            if ((messageCooldownSeconds = messages.getInt("send-message-cooldown", 3)) < 0) {
                messageCooldownSeconds = 0;
            }
            Messages.clearAllCooldowns();
            plugin.getLogger().info("Loaded messages from: " + messagesFile.getAbsolutePath());
            plugin.getLogger().info("Message cooldown: " + (String)(messageCooldownSeconds > 0 ? messageCooldownSeconds + " seconds" : "disabled"));
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to load messages-wgefp.yml", e);
            messages = new YamlConfiguration();
            messageCooldownSeconds = 3;
        }
    }

    public static String getMessage(String key, String ... replacements) {
        String message = messages.getString(key, "&cMessage not found: " + key);
        if (message == null || message.trim().isEmpty()) {
            return null;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String getRawMessage(String key) {
        return messages.getString(key, "");
    }

    public static boolean sendMessageWithCooldown(Player player, String key, String ... replacements) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        String message = Messages.getMessage(key, replacements);
        if (message == null) {
            return false;
        }
        if (messageCooldownSeconds > 0) {
            long timeSinceLastMessage;
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            long cooldownMillis = (long)messageCooldownSeconds * 1000L;
            Long lastMessageTime = messageCooldowns.get(playerId);
            if (lastMessageTime != null && (timeSinceLastMessage = currentTime - lastMessageTime) < cooldownMillis) {
                return false;
            }
            messageCooldowns.put(playerId, currentTime);
        }
        player.sendMessage(message);
        return true;
    }

    public static void clearCooldown(Player player) {
        if (player != null) {
            messageCooldowns.remove(player.getUniqueId());
        }
    }

    public static void clearAllCooldowns() {
        messageCooldowns.clear();
    }

    public static File getMessagesFile() {
        return messagesFile;
    }

    public static int getMessageCooldownSeconds() {
        return messageCooldownSeconds;
    }

    static {
        messageCooldowns = new ConcurrentHashMap();
    }
}

