/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private static JavaPlugin plugin;
    private static FileConfiguration config;
    private static File configFile;
    private static boolean permitWorkbenchBlockPlacementToo;
    private static boolean permitAllIncludesEnderchest;

    public static void initialize(JavaPlugin plugin) {
        Config.plugin = plugin;
        File worldGuardDataFolder = plugin.getServer().getPluginManager().getPlugin("WorldGuard").getDataFolder();
        configFile = new File(worldGuardDataFolder, "config-wgefp.yml");
        if (!configFile.exists()) {
            Config.saveDefaultConfig(worldGuardDataFolder);
        }
        Config.reloadConfig();
    }

    private static void saveDefaultConfig(File worldGuardDataFolder) {
        try {
            int length;
            if (!worldGuardDataFolder.exists()) {
                worldGuardDataFolder.mkdirs();
            }
            if (configFile.exists()) {
                plugin.getLogger().info("config-wgefp.yml already exists in WorldGuard folder, skipping default copy.");
                return;
            }
            InputStream defaultStream = plugin.getResource("config-wgefp.yml");
            if (defaultStream == null) {
                plugin.getLogger().warning("Default config-wgefp.yml not found in plugin resources!");
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(configFile);
            byte[] buffer = new byte[1024];
            while ((length = defaultStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            defaultStream.close();
            plugin.getLogger().info("Created config-wgefp.yml in WorldGuard folder: " + configFile.getAbsolutePath());
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to save default config-wgefp.yml", e);
        }
    }

    public static void reloadConfig() {
        try {
            config = YamlConfiguration.loadConfiguration((File)configFile);
            InputStream defaultStream = plugin.getResource("config-wgefp.yml");
            if (defaultStream != null) {
                InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                config.setDefaults((Configuration)defaultConfig);
            }
            permitWorkbenchBlockPlacementToo = config.getBoolean("permit-workbenches.permit-workbench-block-placement-too", false);
            permitAllIncludesEnderchest = config.getBoolean("permit-workbenches.permit-all-includes-enderchest", false);
            plugin.getLogger().info("Loaded config from: " + configFile.getAbsolutePath());
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to load config-wgefp.yml", e);
            permitWorkbenchBlockPlacementToo = false;
            permitAllIncludesEnderchest = false;
        }
    }

    public static boolean isPermitWorkbenchBlockPlacementToo() {
        return permitWorkbenchBlockPlacementToo;
    }

    public static boolean isPermitAllIncludesEnderchest() {
        return permitAllIncludesEnderchest;
    }

    public static File getConfigFile() {
        return configFile;
    }

    static {
        permitWorkbenchBlockPlacementToo = false;
        permitAllIncludesEnderchest = false;
    }
}

