/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.data.PotionEffectDetails;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GiveEffectsFlagHandler
extends FlagValueChangeHandler<Set<PotionEffect>> {
    private Map<PotionEffectType, PotionEffectDetails> removedEffects = new ConcurrentHashMap<PotionEffectType, PotionEffectDetails>();
    private Set<PotionEffectType> givenEffects = ConcurrentHashMap.newKeySet();
    private boolean supressRemovePotionPacket;

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected GiveEffectsFlagHandler(Session session) {
        super(session, Flags.GIVE_EFFECTS);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Set<PotionEffect> value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<PotionEffect> currentValue, Set<PotionEffect> lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<PotionEffect> lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    public void tick(LocalPlayer player, ApplicableRegionSet set) {
        this.handleValue(player, player.getWorld(), (Set)set.queryValue((RegionAssociable)player, Flags.GIVE_EFFECTS));
    }

    private void handleValue(LocalPlayer player, World world, Set<PotionEffect> value) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            if (!this.getSession().getManager().hasBypass(player, world) && value != null) {
                try {
                    for (PotionEffect effect : value) {
                        PotionEffect effect_ = null;
                        for (PotionEffect activeEffect : bukkitPlayer.getActivePotionEffects()) {
                            if (!activeEffect.getType().equals(effect.getType())) continue;
                            effect_ = activeEffect;
                            break;
                        }
                        boolean bl = this.supressRemovePotionPacket = effect_ != null && effect_.getAmplifier() == effect.getAmplifier();
                        if (this.givenEffects.add(effect.getType()) && effect_ != null) {
                            this.removedEffects.put(effect_.getType(), new PotionEffectDetails(System.nanoTime() + (long)((double)effect_.getDuration() / 20.0 * (double)TimeUnit.SECONDS.toNanos(1L)), effect_.getAmplifier(), effect_.isAmbient(), effect_.hasParticles()));
                            bukkitPlayer.removePotionEffect(effect_.getType());
                        }
                        bukkitPlayer.addPotionEffect(effect, true);
                    }
                }
                finally {
                    this.supressRemovePotionPacket = false;
                }
            }
            Iterator<PotionEffectType> effectTypes = this.givenEffects.iterator();
            while (effectTypes.hasNext()) {
                PotionEffectType type = effectTypes.next();
                if (value != null && value.size() > 0) {
                    boolean skip = false;
                    for (PotionEffect effect : value) {
                        if (!effect.getType().equals(type)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                bukkitPlayer.removePotionEffect(type);
                effectTypes.remove();
            }
            Iterator<Map.Entry<PotionEffectType, PotionEffectDetails>> potionEffects_ = this.removedEffects.entrySet().iterator();
            while (potionEffects_.hasNext()) {
                int timeLeft;
                Map.Entry<PotionEffectType, PotionEffectDetails> effect = potionEffects_.next();
                if (this.givenEffects.contains(effect.getKey())) continue;
                PotionEffectDetails removedEffect = effect.getValue();
                if (removedEffect != null && (timeLeft = removedEffect.getTimeLeftInTicks()) > 0) {
                    bukkitPlayer.addPotionEffect(new PotionEffect(effect.getKey(), timeLeft, removedEffect.getAmplifier(), removedEffect.isAmbient(), removedEffect.isParticles()), true);
                }
                potionEffects_.remove();
            }
        });
    }

    public void drinkMilk(Player bukkitPlayer) {
        this.removedEffects.clear();
        LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer(bukkitPlayer);
        Set value = (Set)WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(player.getLocation()).queryValue((RegionAssociable)player, Flags.GIVE_EFFECTS);
        this.handleValue(player, player.getWorld(), value);
    }

    public void drinkPotion(Player bukkitPlayer, Collection<PotionEffect> effects) {
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            for (PotionEffect effect : effects) {
                this.removedEffects.put(effect.getType(), new PotionEffectDetails(System.nanoTime() + (long)((double)effect.getDuration() / 20.0 * (double)TimeUnit.SECONDS.toNanos(1L)), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()));
            }
            LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer(bukkitPlayer);
            Set value = (Set)WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(player.getLocation()).queryValue((RegionAssociable)player, Flags.GIVE_EFFECTS);
            this.handleValue(player, player.getWorld(), value);
        });
    }

    @Generated
    public boolean isSupressRemovePotionPacket() {
        return this.supressRemovePotionPacket;
    }

    public static class Factory
    extends Handler.Factory<GiveEffectsFlagHandler> {
        public GiveEffectsFlagHandler create(Session session) {
            return new GiveEffectsFlagHandler(session);
        }
    }
}

