/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class CollisionFlagHandler
extends FlagValueChangeHandler<Boolean> {
    private static final String TEAM_NAME = "WGEFP_COLLISION";

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected CollisionFlagHandler(Session session) {
        super(session, (Flag)Flags.DISABLE_COLLISION);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Boolean value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Boolean currentValue, Boolean lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Boolean lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    private void handleValue(LocalPlayer player, World world, Boolean disableCollision) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        if (this.getSession().getManager().hasBypass(player, world)) {
            WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> this.removeFromCollisionTeam(bukkitPlayer));
            return;
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            if (disableCollision != null && disableCollision.booleanValue()) {
                this.addToCollisionTeam(bukkitPlayer);
            } else {
                this.removeFromCollisionTeam(bukkitPlayer);
            }
        });
    }

    private void addToCollisionTeam(Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        Team team = scoreboard.getTeam(TEAM_NAME);
        if (team == null) {
            team = scoreboard.registerNewTeam(TEAM_NAME);
        }
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        if (!team.hasEntry(player.getName())) {
            team.addEntry(player.getName());
        }
    }

    private void removeFromCollisionTeam(Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        Team team = scoreboard.getTeam(TEAM_NAME);
        if (team != null && team.hasEntry(player.getName())) {
            team.removeEntry(player.getName());
        }
    }

    public static class Factory
    extends Handler.Factory<CollisionFlagHandler> {
        public CollisionFlagHandler create(Session session) {
            return new CollisionFlagHandler(session);
        }
    }
}

