/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.data.PotionEffectDetails;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlockedEffectsFlagHandler
extends FlagValueChangeHandler<Set<PotionEffectType>> {
    private ConcurrentHashMap<PotionEffectType, PotionEffectDetails> removedEffects = new ConcurrentHashMap();

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected BlockedEffectsFlagHandler(Session session) {
        super(session, Flags.BLOCKED_EFFECTS);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Set<PotionEffectType> value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<PotionEffectType> currentValue, Set<PotionEffectType> lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<PotionEffectType> lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    public void tick(LocalPlayer player, ApplicableRegionSet set) {
        this.handleValue(player, player.getWorld(), (Set)set.queryValue((RegionAssociable)player, Flags.BLOCKED_EFFECTS));
    }

    private void handleValue(LocalPlayer player, World world, Set<PotionEffectType> value) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        if (!this.getSession().getManager().hasBypass(player, world) && value != null) {
            for (PotionEffectType effectType : value) {
                PotionEffect effect = null;
                for (PotionEffect activeEffect : bukkitPlayer.getActivePotionEffects()) {
                    if (!activeEffect.getType().equals(effectType)) continue;
                    effect = activeEffect;
                    break;
                }
                if (effect == null) continue;
                this.removedEffects.put(effect.getType(), new PotionEffectDetails(System.nanoTime() + (long)((double)effect.getDuration() / 20.0 * (double)TimeUnit.SECONDS.toNanos(1L)), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()));
                WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, wrappedTask -> bukkitPlayer.removePotionEffect(effectType));
            }
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            Iterator<Map.Entry<PotionEffectType, PotionEffectDetails>> iterator = this.removedEffects.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PotionEffectType, PotionEffectDetails> entry = iterator.next();
                PotionEffectType type = entry.getKey();
                if (value != null && value.contains(type)) continue;
                PotionEffectDetails details = entry.getValue();
                int timeLeft = details.getTimeLeftInTicks();
                if (timeLeft > 0) {
                    PotionEffect effect = new PotionEffect(type, timeLeft, details.getAmplifier(), details.isAmbient(), details.isParticles());
                    bukkitPlayer.addPotionEffect(effect, true);
                }
                iterator.remove();
            }
        });
    }

    public static class Factory
    extends Handler.Factory<BlockedEffectsFlagHandler> {
        public BlockedEffectsFlagHandler create(Session session) {
            return new BlockedEffectsFlagHandler(session);
        }
    }
}

