/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class VillagerTradeListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)villager.getLocation()));
        StateFlag.State state = regions.queryState((RegionAssociable)localPlayer, new StateFlag[]{Flags.VILLAGER_TRADE});
        if (state == StateFlag.State.DENY) {
            event.setCancelled(true);
        }
    }

    @Generated
    public VillagerTradeListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }
}

