/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.wg.handlers.GiveEffectsFlagHandler;
import lombok.Generated;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPotionEffectEventListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final SessionManager sessionManager;

    @EventHandler(ignoreCancelled=true)
    public void onEntityPotionEffectEvent(EntityPotionEffectEvent event) {
        Player player;
        if (event.getAction() != EntityPotionEffectEvent.Action.REMOVED || event.getCause() != EntityPotionEffectEvent.Cause.PLUGIN) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || !(player = (Player)entity).isValid()) {
            return;
        }
        try {
            Session session = this.sessionManager.get(this.worldGuardPlugin.wrapPlayer(player));
            GiveEffectsFlagHandler giveEffectsHandler = (GiveEffectsFlagHandler)session.getHandler(GiveEffectsFlagHandler.class);
            if (giveEffectsHandler.isSupressRemovePotionPacket()) {
                event.setCancelled(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Generated
    public EntityPotionEffectEventListener(WorldGuardPlugin worldGuardPlugin, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.sessionManager = sessionManager;
    }
}

