/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.updater;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String currentVersion;
    private final int spigotResourceId;
    private final String githubRepository;
    private final String modrinthProjectId;

    public UpdateChecker(JavaPlugin plugin, int spigotResourceId, String githubRepository, String modrinthProjectId) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.spigotResourceId = spigotResourceId;
        this.githubRepository = githubRepository;
        this.modrinthProjectId = modrinthProjectId;
    }

    public void checkForUpdates() {
        ArrayList<CompletableFuture<UpdateResult>> futures = new ArrayList<CompletableFuture<UpdateResult>>();
        if (this.spigotResourceId > 0) {
            futures.add(this.checkSpigotUpdatesAsync());
        }
        if (this.githubRepository != null && !this.githubRepository.isEmpty()) {
            futures.add(this.checkGitHubUpdatesAsync());
        }
        if (this.modrinthProjectId != null && !this.modrinthProjectId.isEmpty()) {
            futures.add(this.checkModrinthUpdatesAsync());
        }
        if (futures.isEmpty()) {
            this.plugin.getLogger().info("Update checker is disabled (no update sources configured)");
            return;
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            ArrayList<UpdateResult> results = new ArrayList<UpdateResult>();
            for (CompletableFuture future : futures) {
                try {
                    UpdateResult result = (UpdateResult)future.get();
                    if (result == null || !result.hasUpdate) continue;
                    results.add(result);
                }
                catch (Exception exception) {}
            }
            if (!results.isEmpty()) {
                this.printUpdateResults(results);
            }
        });
    }

    private void printUpdateResults(List<UpdateResult> results) {
        this.plugin.getLogger().info("=================== [WorldGuard ExtraFlag Plus] ======================");
        for (UpdateResult result : results) {
            String displayLatestVersion = this.normalizeVersion(result.latestVersion);
            this.plugin.getLogger().info("[" + result.source + "] An update is available! Current: " + this.currentVersion + " - Latest: " + displayLatestVersion);
            this.plugin.getLogger().info("Download: " + result.downloadUrl);
        }
        this.plugin.getLogger().info("=================== [WorldGuard ExtraFlag Plus] ======================");
    }

    private String normalizeVersion(String version) {
        if (version == null) {
            return null;
        }
        if ((version = version.trim()).startsWith("v.") || version.startsWith("V.")) {
            version = version.substring(2);
        } else if (version.startsWith("v") || version.startsWith("V")) {
            version = version.substring(1);
        }
        return version;
    }

    private int[] parseVersion(String version) {
        String[] parts;
        if (version == null || version.isEmpty()) {
            return null;
        }
        version = this.normalizeVersion(version);
        int dashIndex = version.indexOf(45);
        int plusIndex = version.indexOf(43);
        if (dashIndex != -1 || plusIndex != -1) {
            int cutIndex = dashIndex != -1 && plusIndex != -1 ? Math.min(dashIndex, plusIndex) : (dashIndex != -1 ? dashIndex : plusIndex);
            version = version.substring(0, cutIndex);
        }
        if ((parts = version.split("\\.")).length < 2) {
            return null;
        }
        try {
            int[] versionParts = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                versionParts[i] = Integer.parseInt(parts[i]);
            }
            return versionParts;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Integer compareVersions(String version1, String version2) {
        int[] v1Parts = this.parseVersion(version1);
        int[] v2Parts = this.parseVersion(version2);
        if (v1Parts == null || v2Parts == null) {
            return null;
        }
        int maxLength = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < maxLength; ++i) {
            int v2Part;
            int v1Part = i < v1Parts.length ? v1Parts[i] : 0;
            int n = v2Part = i < v2Parts.length ? v2Parts[i] : 0;
            if (v1Part < v2Part) {
                return -1;
            }
            if (v1Part <= v2Part) continue;
            return 1;
        }
        return 0;
    }

    private boolean isNewerVersion(String fetchedVersion) {
        Integer comparison = this.compareVersions(fetchedVersion, this.currentVersion);
        if (comparison == null) {
            return false;
        }
        return comparison > 0;
    }

    private CompletableFuture<UpdateResult> checkSpigotUpdatesAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = URI.create("https://api.spigotmc.org/legacy/update.php?resource=" + this.spigotResourceId).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String latestVersion = reader.readLine();
                    if (latestVersion == null) return null;
                    if (latestVersion.isEmpty()) return null;
                    String displayVersion = (latestVersion = latestVersion.trim()).startsWith("v") || latestVersion.startsWith("V") ? latestVersion : "v" + latestVersion;
                    boolean hasUpdate = this.isNewerVersion(latestVersion);
                    UpdateResult updateResult = new UpdateResult("Spigot", displayVersion, "https://www.spigotmc.org/resources/" + this.spigotResourceId, hasUpdate);
                    return updateResult;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to check for updates from Spigot: " + e.getMessage());
            }
            return null;
        });
    }

    private CompletableFuture<UpdateResult> checkGitHubUpdatesAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = URI.create("https://api.github.com/repos/" + this.githubRepository + "/releases/latest").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String tag;
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String json = response.toString();
                    int tagIndex = json.indexOf("\"tag_name\"");
                    if (tagIndex == -1) return null;
                    int startIndex = json.indexOf("\"", tagIndex + 10) + 1;
                    int endIndex = json.indexOf("\"", startIndex);
                    if (startIndex <= 0) return null;
                    if (endIndex <= startIndex) return null;
                    String displayVersion = tag = json.substring(startIndex, endIndex);
                    boolean hasUpdate = this.isNewerVersion(tag);
                    UpdateResult updateResult = new UpdateResult("GitHub", displayVersion, "https://github.com/" + this.githubRepository + "/releases/latest", hasUpdate);
                    return updateResult;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to check for updates from GitHub: " + e.getMessage());
            }
            return null;
        });
    }

    private CompletableFuture<UpdateResult> checkModrinthUpdatesAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = URI.create("https://api.modrinth.com/v2/project/" + this.modrinthProjectId).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("User-Agent", "WorldGuardExtraFlagsPlus/" + this.currentVersion);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String json = response.toString();
                    int versionsIndex = json.indexOf("\"versions\"");
                    if (versionsIndex == -1) return null;
                    int arrayStart = json.indexOf("[", versionsIndex);
                    int arrayEnd = json.indexOf("]", arrayStart);
                    if (arrayStart == -1) return null;
                    if (arrayEnd == -1) return null;
                    String versionsArray = json.substring(arrayStart + 1, arrayEnd);
                    int firstQuote = versionsArray.indexOf("\"");
                    int secondQuote = versionsArray.indexOf("\"", firstQuote + 1);
                    if (firstQuote == -1) return null;
                    if (secondQuote == -1) return null;
                    String versionId = versionsArray.substring(firstQuote + 1, secondQuote);
                    String latestVersion = this.fetchModrinthVersionNumber(versionId);
                    if (latestVersion == null) return null;
                    String displayVersion = latestVersion.startsWith("v") || latestVersion.startsWith("V") ? latestVersion : "v" + latestVersion;
                    boolean hasUpdate = this.isNewerVersion(latestVersion);
                    UpdateResult updateResult = new UpdateResult("Modrinth", displayVersion, "https://modrinth.com/plugin/" + this.modrinthProjectId, hasUpdate);
                    return updateResult;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to check for updates from Modrinth: " + e.getMessage());
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchModrinthVersionNumber(String versionId) {
        try {
            URL url = URI.create("https://api.modrinth.com/v2/version/" + versionId).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("User-Agent", "WorldGuardExtraFlagsPlus/" + this.currentVersion);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                String json = response.toString();
                int versionNumberIndex = json.indexOf("\"version_number\"");
                if (versionNumberIndex == -1) return null;
                int startIndex = json.indexOf("\"", versionNumberIndex + 17) + 1;
                int endIndex = json.indexOf("\"", startIndex);
                if (startIndex <= 0) return null;
                if (endIndex <= startIndex) return null;
                String version = json.substring(startIndex, endIndex);
                if (version.startsWith("v")) {
                    version = version.substring(1);
                }
                String string = version;
                return string;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to fetch Modrinth version details: " + e.getMessage());
        }
        return null;
    }

    private static class UpdateResult {
        final String source;
        final String latestVersion;
        final String downloadUrl;
        final boolean hasUpdate;

        UpdateResult(String source, String latestVersion, String downloadUrl, boolean hasUpdate) {
            this.source = source;
            this.latestVersion = latestVersion;
            this.downloadUrl = downloadUrl;
            this.hasUpdate = hasUpdate;
        }
    }
}

