/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.Messages;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.helpers.BlockableItemFlag;
import dev.tins.worldguardextraflagsplus.flags.helpers.ForcedStateFlag;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EntityListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;
    private static final Set<String> BLOCKABLE_ITEMS = BlockableItemFlag.getBlockableItems();

    @EventHandler(ignoreCancelled=true)
    public void onPortalCreateEvent(PortalCreateEvent event) {
        LocalPlayer localPlayer;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            localPlayer = this.worldGuardPlugin.wrapPlayer(player);
            if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
                return;
            }
        } else {
            localPlayer = null;
        }
        for (BlockState block : event.getBlocks()) {
            if (this.regionContainer.createQuery().queryState(BukkitAdapter.adapt((Location)block.getLocation()), localPlayer, new StateFlag[]{Flags.NETHER_PORTALS}) != StateFlag.State.DENY) continue;
            event.setCancelled(true);
            break;
        }
    }

    private boolean isBlocked(LocalPlayer localPlayer, Material material) {
        String name = material.name();
        if (!BLOCKABLE_ITEMS.contains(name)) {
            return false;
        }
        ApplicableRegionSet regions = this.regionContainer.createQuery().getApplicableRegions(localPlayer.getLocation());
        Set set = (Set)regions.queryValue((RegionAssociable)localPlayer, Flags.PERMIT_COMPLETELY);
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String item : set) {
            if (item == null || !item.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void sendBlocked(Player player, String itemName) {
        Messages.sendMessageWithCooldown(player, "permit-completely-blocked", "item", itemName);
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material mat = item.getType();
        if (mat == Material.AIR) {
            return;
        }
        if (this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Material mat;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        Material mat;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectile(ProjectileLaunchEvent event) {
        Material mat;
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material material = mat = item != null ? item.getType() : Material.AIR;
        if (mat != Material.AIR && this.isBlocked(localPlayer, mat)) {
            event.setCancelled(true);
            this.sendBlocked(player, mat.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityResurrectEvent(EntityResurrectEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
        if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        Material totemMaterial = Material.TOTEM_OF_UNDYING;
        if (mainHand != null && mainHand.getType() == totemMaterial && this.isBlocked(localPlayer, totemMaterial)) {
            event.setCancelled(true);
            this.sendBlocked(player, totemMaterial.name());
            return;
        }
        if (offHand != null && offHand.getType() == totemMaterial && this.isBlocked(localPlayer, totemMaterial)) {
            event.setCancelled(true);
            this.sendBlocked(player, totemMaterial.name());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(player);
            if (this.sessionManager.hasBypass(localPlayer, localPlayer.getWorld())) {
                return;
            }
            ForcedStateFlag.ForcedState state = (ForcedStateFlag.ForcedState)((Object)this.regionContainer.createQuery().queryValue(localPlayer.getLocation(), localPlayer, (Flag)Flags.GLIDE));
            switch (state) {
                case ALLOW: {
                    break;
                }
                case DENY: {
                    if (!event.isGliding()) {
                        return;
                    }
                    event.setCancelled(true);
                    WorldGuardUtils.getScheduler().runAtEntity((Entity)player, task -> {
                        Vector velocity = player.getVelocity();
                        velocity.setY(Math.min(velocity.getY(), -0.5));
                        player.setVelocity(velocity);
                    });
                    break;
                }
                case FORCE: {
                    if (event.isGliding()) {
                        return;
                    }
                    event.setCancelled(true);
                }
            }
        }
    }

    @Generated
    public EntityListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }
}

