/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.Messages;
import dev.tins.worldguardextraflagsplus.bstats.bukkit.Metrics;
import dev.tins.worldguardextraflagsplus.commands.ReloadCommand;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.listeners.BlockListener;
import dev.tins.worldguardextraflagsplus.listeners.EntityListener;
import dev.tins.worldguardextraflagsplus.listeners.EntityPotionEffectEventListener;
import dev.tins.worldguardextraflagsplus.listeners.PlayerListener;
import dev.tins.worldguardextraflagsplus.listeners.VillagerTradeListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldEditListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldGuardReloadListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldListener;
import dev.tins.worldguardextraflagsplus.protocollib.ProtocolLibHelper;
import dev.tins.worldguardextraflagsplus.updater.UpdateChecker;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import dev.tins.worldguardextraflagsplus.wg.handlers.BlockedEffectsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CollisionFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CommandOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CommandOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.ConsoleCommandOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.ConsoleCommandOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.EntryLevelFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.FlyFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.FlySpeedFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GiveEffectsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GlideFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GodmodeFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.PlaySoundsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.TeleportOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.TeleportOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.WalkSpeedFlagHandler;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldGuardExtraFlagsPlusPlugin
extends JavaPlugin {
    private static final Set<Flag<?>> FLAGS = WorldGuardExtraFlagsPlusPlugin.getPluginFlags();
    private static WorldGuardExtraFlagsPlusPlugin plugin;
    private WorldEditPlugin worldEditPlugin;
    private WorldGuardPlugin worldGuardPlugin;
    private WorldGuard worldGuard;
    private RegionContainer regionContainer;
    private SessionManager sessionManager;
    private ProtocolLibHelper protocolLibHelper;

    public WorldGuardExtraFlagsPlusPlugin() {
        plugin = this;
    }

    public void onLoad() {
        this.worldEditPlugin = (WorldEditPlugin)this.getServer().getPluginManager().getPlugin("WorldEdit");
        this.worldGuardPlugin = (WorldGuardPlugin)this.getServer().getPluginManager().getPlugin("WorldGuard");
        this.worldGuard = WorldGuard.getInstance();
        try {
            FlagRegistry flagRegistry = this.worldGuard.getFlagRegistry();
            flagRegistry.register((Flag)Flags.TELEPORT_ON_ENTRY);
            flagRegistry.register((Flag)Flags.TELEPORT_ON_EXIT);
            flagRegistry.register(Flags.COMMAND_ON_ENTRY);
            flagRegistry.register(Flags.COMMAND_ON_EXIT);
            flagRegistry.register(Flags.CONSOLE_COMMAND_ON_ENTRY);
            flagRegistry.register(Flags.CONSOLE_COMMAND_ON_EXIT);
            flagRegistry.register((Flag)Flags.WALK_SPEED);
            flagRegistry.register((Flag)Flags.KEEP_INVENTORY);
            flagRegistry.register((Flag)Flags.KEEP_EXP);
            flagRegistry.register((Flag)Flags.CHAT_PREFIX);
            flagRegistry.register((Flag)Flags.CHAT_SUFFIX);
            flagRegistry.register(Flags.BLOCKED_EFFECTS);
            flagRegistry.register((Flag)Flags.GODMODE);
            flagRegistry.register((Flag)Flags.RESPAWN_LOCATION);
            flagRegistry.register((Flag)Flags.WORLDEDIT);
            flagRegistry.register(Flags.GIVE_EFFECTS);
            flagRegistry.register((Flag)Flags.FLY);
            flagRegistry.register((Flag)Flags.FLY_SPEED);
            flagRegistry.register(Flags.PLAY_SOUNDS);
            flagRegistry.register((Flag)Flags.FROSTWALKER);
            flagRegistry.register((Flag)Flags.NETHER_PORTALS);
            flagRegistry.register((Flag)Flags.GLIDE);
            flagRegistry.register((Flag)Flags.CHUNK_UNLOAD);
            flagRegistry.register((Flag)Flags.ITEM_DURABILITY);
            flagRegistry.register((Flag)Flags.JOIN_LOCATION);
            flagRegistry.register(Flags.PERMIT_COMPLETELY);
            flagRegistry.register(Flags.ENTRY_MIN_LEVEL);
            flagRegistry.register(Flags.ENTRY_MAX_LEVEL);
            flagRegistry.register((Flag)Flags.VILLAGER_TRADE);
            flagRegistry.register((Flag)Flags.DISABLE_COLLISION);
        }
        catch (Exception e) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            throw new RuntimeException(e instanceof IllegalStateException ? "WorldGuard prevented flag registration. Did you reload the plugin? This is not supported!" : "Flag registration failed!", e);
        }
        try {
            Plugin protocolLibPlugin = this.getServer().getPluginManager().getPlugin("ProtocolLib");
            if (protocolLibPlugin != null) {
                this.protocolLibHelper = new ProtocolLibHelper(this, protocolLibPlugin);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onEnable() {
        Messages.initialize(this);
        WorldGuardUtils.initializeScheduler((Plugin)this);
        this.regionContainer = this.worldGuard.getPlatform().getRegionContainer();
        this.sessionManager = this.worldGuard.getPlatform().getSessionManager();
        this.sessionManager.registerHandler((Handler.Factory)TeleportOnEntryFlagHandler.FACTORY((Plugin)plugin), null);
        this.sessionManager.registerHandler((Handler.Factory)TeleportOnExitFlagHandler.FACTORY((Plugin)plugin), null);
        this.sessionManager.registerHandler((Handler.Factory)WalkSpeedFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)FlySpeedFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)FlyFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)GlideFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)GodmodeFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)PlaySoundsFlagHandler.FACTORY((Plugin)plugin), null);
        this.sessionManager.registerHandler((Handler.Factory)BlockedEffectsFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)GiveEffectsFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)CommandOnEntryFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)CommandOnExitFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)ConsoleCommandOnEntryFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)ConsoleCommandOnExitFlagHandler.FACTORY(), null);
        this.sessionManager.registerHandler((Handler.Factory)EntryLevelFlagHandler.FACTORY((Plugin)plugin), null);
        this.sessionManager.registerHandler((Handler.Factory)CollisionFlagHandler.FACTORY(), null);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this, this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this, this.regionContainer), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerTradeListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldGuardReloadListener(this), (Plugin)this);
        this.worldEditPlugin.getWorldEdit().getEventBus().register((Object)new WorldEditListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager));
        if (this.protocolLibHelper != null) {
            try {
                this.protocolLibHelper.onEnable();
            }
            catch (Throwable ignore) {
                this.getServer().getPluginManager().registerEvents((Listener)new EntityPotionEffectEventListener(this.worldGuardPlugin, this.sessionManager), (Plugin)this);
            }
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new EntityPotionEffectEventListener(this.worldGuardPlugin, this.sessionManager), (Plugin)this);
        }
        for (World world : this.getServer().getWorlds()) {
            this.doUnloadChunkFlagCheck(world);
        }
        this.setupMetrics();
        this.setupUpdateChecker();
        this.getCommand("wgefp").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("wgefp").setTabCompleter((TabCompleter)new ReloadCommand(this));
    }

    public void doUnloadChunkFlagCheck(World world) {
        RegionManager regionManager = this.regionContainer.get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return;
        }
        for (ProtectedRegion region : regionManager.getRegions().values()) {
            if (region.getFlag((Flag)Flags.CHUNK_UNLOAD) != StateFlag.State.DENY) continue;
            this.getLogger().info("Loading chunks for region " + region.getId() + " located in " + world.getName() + " due to chunk-unload flag being deny");
            BlockVector3 min = region.getMinimumPoint();
            BlockVector3 max = region.getMaximumPoint();
            for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
                for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                    world.getChunkAt(x, z).addPluginChunkTicket((Plugin)this);
                }
            }
        }
    }

    private void setupMetrics() {
        int bStatsPluginId = 27821;
        try {
            Metrics metrics = new Metrics(this, 27821);
            this.getLogger().info("bStats metrics enabled (ID: 27821)");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to initialize bStats metrics: " + e.getMessage());
        }
    }

    private void setupUpdateChecker() {
        int spigotResourceId = 129946;
        String githubRepository = "tins-dev/WorldGuardExtraFlagsPlus";
        String modrinthProjectId = "worldguard-extraflags-plus";
        WorldGuardUtils.getScheduler().runNextTick(task -> WorldGuardUtils.getScheduler().runNextTick(delayedTask -> {
            UpdateChecker updateChecker = new UpdateChecker(this, spigotResourceId, githubRepository, modrinthProjectId);
            updateChecker.checkForUpdates();
        }));
    }

    private static Set<Flag<?>> getPluginFlags() {
        HashSet flags = new HashSet();
        for (Field field : Flags.class.getFields()) {
            try {
                flags.add((Flag)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return flags;
    }

    @Generated
    public static WorldGuardExtraFlagsPlusPlugin getPlugin() {
        return plugin;
    }

    @Generated
    public WorldEditPlugin getWorldEditPlugin() {
        return this.worldEditPlugin;
    }

    @Generated
    public WorldGuardPlugin getWorldGuardPlugin() {
        return this.worldGuardPlugin;
    }

    @Generated
    public WorldGuard getWorldGuard() {
        return this.worldGuard;
    }

    @Generated
    public RegionContainer getRegionContainer() {
        return this.regionContainer;
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Generated
    public ProtocolLibHelper getProtocolLibHelper() {
        return this.protocolLibHelper;
    }
}

