/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeleportOnExitFlagHandler
extends FlagValueChangeHandler<Location> {
    private final Plugin plugin;

    public static final Factory FACTORY(Plugin plugin) {
        return new Factory(plugin);
    }

    protected TeleportOnExitFlagHandler(Plugin plugin, Session session) {
        super(session, (Flag)Flags.TELEPORT_ON_EXIT);
        this.plugin = plugin;
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Location value) {
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Location currentValue, Location lastValue, MoveType moveType) {
        this.handleValue(player, (World)from.getExtent(), lastValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Location lastValue, MoveType moveType) {
        this.handleValue(player, (World)from.getExtent(), lastValue);
        return true;
    }

    public void handleValue(LocalPlayer player, World world, Location value) {
        if (this.getSession().getManager().hasBypass(player, world)) {
            return;
        }
        if (value != null && WorldGuardUtils.hasNoTeleportLoop(this.plugin, ((BukkitPlayer)player).getPlayer(), value)) {
            Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
            if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
                return;
            }
            WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> player.setLocation(value));
        }
    }

    public static class Factory
    extends Handler.Factory<TeleportOnExitFlagHandler> {
        private final Plugin plugin;

        public Factory(Plugin plugin) {
            this.plugin = plugin;
        }

        public TeleportOnExitFlagHandler create(Session session) {
            return new TeleportOnExitFlagHandler(this.plugin, session);
        }
    }
}

