/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.data.SoundData;
import dev.tins.worldguardextraflagsplus.folialib.wrapper.task.WrappedTask;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaySoundsFlagHandler
extends FlagValueChangeHandler<Set<SoundData>> {
    private final Plugin plugin;
    private Map<String, WrappedRunnable> runnables;

    public static final Factory FACTORY(Plugin plugin) {
        return new Factory(plugin);
    }

    protected PlaySoundsFlagHandler(Plugin plugin, Session session) {
        super(session, Flags.PLAY_SOUNDS);
        this.plugin = plugin;
        this.runnables = new ConcurrentHashMap<String, WrappedRunnable>();
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Set<SoundData> value) {
        this.handleValue(player, value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<SoundData> currentValue, Set<SoundData> lastValue, MoveType moveType) {
        this.handleValue(player, currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<SoundData> lastValue, MoveType moveType) {
        this.handleValue(player, null);
        return true;
    }

    public void tick(LocalPlayer player, ApplicableRegionSet set) {
        this.handleValue(player, (Set)set.queryValue((RegionAssociable)player, Flags.PLAY_SOUNDS));
    }

    private void handleValue(LocalPlayer player, Set<SoundData> value) {
        final Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (value != null && value.size() > 0) {
            for (final SoundData sound : value) {
                if (this.runnables.containsKey(sound.sound())) continue;
                WrappedRunnable runnable = new WrappedRunnable(){
                    private WrappedTask wrappedTask;

                    @Override
                    public void run() {
                        bukkitPlayer.playSound(bukkitPlayer.getLocation(), sound.sound(), sound.source(), sound.volume(), sound.pitch());
                    }

                    @Override
                    public void cancel() {
                        if (this.wrappedTask != null) {
                            this.wrappedTask.cancel();
                        }
                        bukkitPlayer.stopSound(sound.sound(), sound.source());
                    }

                    @Override
                    public void setWrappedTask(WrappedTask wrappedTask) {
                        this.wrappedTask = wrappedTask;
                    }
                };
                WrappedTask wrappedTask = WorldGuardUtils.getScheduler().runAtEntityTimer((Entity)bukkitPlayer, runnable, 1L, (long)sound.interval() * 50L, TimeUnit.MILLISECONDS);
                runnable.setWrappedTask(wrappedTask);
                this.runnables.put(sound.sound(), runnable);
            }
        }
        Iterator<Map.Entry<String, WrappedRunnable>> runnables = this.runnables.entrySet().iterator();
        while (runnables.hasNext()) {
            Map.Entry<String, WrappedRunnable> runnable = runnables.next();
            if (value != null && value.size() > 0) {
                boolean skip = false;
                for (SoundData sound : value) {
                    if (!sound.sound().equals(runnable.getKey())) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            runnable.getValue().cancel();
            runnables.remove();
        }
    }

    public static class Factory
    extends Handler.Factory<PlaySoundsFlagHandler> {
        private final Plugin plugin;

        public Factory(Plugin plugin) {
            this.plugin = plugin;
        }

        public PlaySoundsFlagHandler create(Session session) {
            return new PlaySoundsFlagHandler(this.plugin, session);
        }
    }

    static interface WrappedRunnable
    extends Runnable {
        public void cancel();

        @Override
        public void run();

        public void setWrappedTask(WrappedTask var1);
    }
}

