/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import lombok.Generated;

public class GodmodeFlagHandler
extends FlagValueChangeHandler<StateFlag.State> {
    private Boolean isGodmodeEnabled;
    private Boolean originalEssentialsGodmode;

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected GodmodeFlagHandler(Session session) {
        super(session, (Flag)Flags.GODMODE);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, StateFlag.State value) {
        this.handleValue(player, value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, null);
        return true;
    }

    private void handleValue(LocalPlayer player, StateFlag.State state) {
        this.isGodmodeEnabled = state != null ? Boolean.valueOf(state == StateFlag.State.ALLOW) : null;
    }

    public StateFlag.State getInvincibility(LocalPlayer player) {
        if (this.isGodmodeEnabled != null) {
            return this.isGodmodeEnabled != false ? StateFlag.State.ALLOW : StateFlag.State.DENY;
        }
        return null;
    }

    @Generated
    public Boolean getIsGodmodeEnabled() {
        return this.isGodmodeEnabled;
    }

    public static class Factory
    extends Handler.Factory<GodmodeFlagHandler> {
        public GodmodeFlagHandler create(Session session) {
            return new GodmodeFlagHandler(session);
        }
    }
}

