/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractSpeedFlagHandler
extends FlagValueChangeHandler<Double> {
    private Float originalSpeed;

    protected AbstractSpeedFlagHandler(Session session, DoubleFlag flag) {
        super(session, (Flag)flag);
    }

    protected abstract float getSpeed(Player var1);

    protected abstract void setSpeed(Player var1, float var2);

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Double value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Double currentValue, Double lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Double lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    private void handleValue(LocalPlayer player, World world, Double speed) {
        double clampedSpeed;
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        double finalSpeed = clampedSpeed = speed != null ? Math.max(-1.0, Math.min(1.0, speed)) : 0.0;
        boolean hasSpeed = speed != null;
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            if (!this.getSession().getManager().hasBypass(player, world) && hasSpeed) {
                if ((double)this.getSpeed(bukkitPlayer) != finalSpeed) {
                    if (this.originalSpeed == null) {
                        this.originalSpeed = Float.valueOf(this.getSpeed(bukkitPlayer));
                    }
                    this.setSpeed(bukkitPlayer, (float)finalSpeed);
                }
            } else if (this.originalSpeed != null) {
                this.setSpeed(bukkitPlayer, this.originalSpeed.floatValue());
                this.originalSpeed = null;
            }
        });
    }
}

