/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.we.handlers;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import dev.tins.worldguardextraflagsplus.flags.Flags;

public class WorldEditFlagHandler
extends AbstractDelegateExtent {
    private final LocalPlayer player;
    private final RegionManager regionManager;

    public WorldEditFlagHandler(World ignoredWorld, Extent extent, LocalPlayer player, RegionManager regionManager) {
        super(extent);
        this.player = player;
        this.regionManager = regionManager;
    }

    public boolean setBlock(BlockVector3 location, BlockStateHolder block) throws WorldEditException {
        ApplicableRegionSet regions = this.regionManager.getApplicableRegions(location);
        if (regions.queryState((RegionAssociable)this.player, new StateFlag[]{Flags.WORLDEDIT}) != StateFlag.State.DENY) {
            return super.setBlock(location, block);
        }
        return false;
    }
}

