/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;

public class BlockListener
implements Listener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;

    @EventHandler(ignoreCancelled=true)
    public void onEntityBlockFormEvent(EntityBlockFormEvent event) {
        BlockState newState = event.getNewState();
        if (newState.getType() == Material.FROSTED_ICE) {
            LocalPlayer localPlayer;
            com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)newState.getLocation());
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                localPlayer = this.worldGuardPlugin.wrapPlayer(player);
                if (this.sessionManager.hasBypass(localPlayer, (World)location.getExtent())) {
                    return;
                }
            } else {
                localPlayer = null;
            }
            if (this.regionContainer.createQuery().queryValue(location, localPlayer, (Flag)Flags.FROSTWALKER) == StateFlag.State.DENY) {
                event.setCancelled(true);
            }
        }
    }

    @Generated
    public BlockListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }
}

