/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import dev.tins.worldguardextraflagsplus.flags.data.SoundData;
import java.util.Locale;
import org.bukkit.SoundCategory;

public class SoundDataFlag
extends Flag<SoundData> {
    public SoundDataFlag(String name) {
        super(name);
    }

    public Object marshal(SoundData o) {
        return o.sound() + " " + o.interval() + " " + String.valueOf(o.source()) + " " + o.volume() + " " + o.pitch();
    }

    public SoundData parseInput(FlagContext context) throws InvalidFlagFormat {
        String[] splitd = context.getUserInput().trim().split(" ");
        if (splitd.length >= 2 && splitd.length <= 5) {
            return this.getSoundData(splitd);
        }
        throw new InvalidFlagFormat("Please use format: <sound name> <interval in ticks> [source] [volume] [pitch]");
    }

    public SoundData unmarshal(Object o) {
        String[] splitd = o.toString().split(" ");
        return this.getSoundData(splitd);
    }

    private SoundData getSoundData(String[] splitd) {
        return new SoundData(splitd[0], Integer.parseInt(splitd[1]), splitd.length >= 3 ? SoundCategory.valueOf((String)splitd[2].toUpperCase(Locale.ROOT)) : SoundCategory.MASTER, splitd.length >= 4 ? Float.parseFloat(splitd[3]) : Float.MAX_VALUE, splitd.length >= 5 ? Float.parseFloat(splitd[4]) : 1.0f);
    }
}

