/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectTypeFlag
extends Flag<PotionEffectType> {
    public PotionEffectTypeFlag(String name) {
        super(name);
    }

    public Object marshal(PotionEffectType o) {
        return o.getKey().toString();
    }

    public PotionEffectType parseInput(FlagContext context) throws InvalidFlagFormat {
        PotionEffectType potionEffect = (PotionEffectType)Registry.EFFECT.match(context.getUserInput().trim());
        if (potionEffect == null) {
            potionEffect = PotionEffectType.getByName((String)context.getUserInput().trim());
        }
        if (potionEffect != null) {
            return potionEffect;
        }
        throw new InvalidFlagFormat("Unable to find the potion effect type! Input valid namespaced ids.");
    }

    public PotionEffectType unmarshal(Object o) {
        PotionEffectType potionEffect = (PotionEffectType)Registry.EFFECT.match(o.toString());
        if (potionEffect == null) {
            potionEffect = PotionEffectType.getByName((String)o.toString());
        }
        return potionEffect;
    }
}

