/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectFlag
extends Flag<PotionEffect> {
    private static final int POTION_EFFECT_DURATION = 319;

    public PotionEffectFlag(String name) {
        super(name);
    }

    public Object marshal(PotionEffect o) {
        return o.getType().getKey().toString() + " " + o.getAmplifier() + " " + o.hasParticles();
    }

    public PotionEffect parseInput(FlagContext context) throws InvalidFlagFormat {
        String[] split = context.getUserInput().trim().split(" ");
        if (split.length < 1 || split.length > 3) {
            throw new InvalidFlagFormat("Please use the following format: <effect name> [effect amplifier] [show particles]");
        }
        PotionEffectType potionEffect = (PotionEffectType)Registry.EFFECT.match(split[0]);
        if (potionEffect == null) {
            potionEffect = PotionEffectType.getByName((String)split[0]);
        }
        if (potionEffect == null) {
            throw new InvalidFlagFormat("Unable to find the potion effect type! Input valid namespaced ids.");
        }
        return this.buildPotionEffect(split);
    }

    public PotionEffect unmarshal(Object o) {
        String[] split = o.toString().split(" ");
        return this.buildPotionEffect(split);
    }

    private PotionEffect buildPotionEffect(String[] split) {
        PotionEffectType potionEffect = (PotionEffectType)Registry.EFFECT.match(split[0]);
        if (potionEffect == null) {
            potionEffect = PotionEffectType.getByName((String)split[0]);
        }
        int amplifier = 0;
        if (split.length >= 2) {
            amplifier = Integer.parseInt(split[1]);
        }
        boolean showParticles = false;
        if (split.length >= 3) {
            showParticles = Boolean.parseBoolean(split[2]);
        }
        return new PotionEffect(potionEffect, 319, amplifier, true, showParticles);
    }
}

