/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GodmodeFlagHandler
extends FlagValueChangeHandler<StateFlag.State> {
    private static final ConcurrentHashMap<UUID, Boolean> originalWorldGuardGodmodeCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> originalEssentialsGodmodeCache = new ConcurrentHashMap();
    private static Object essentialsAPI;
    private static boolean essentialsChecked;

    public static final Factory FACTORY() {
        return new Factory();
    }

    private static void initEssentialsAPI() {
        if (essentialsChecked) {
            return;
        }
        essentialsChecked = true;
        try {
            Class<?> iEssentialsClass;
            Plugin essentialsPlugin = Bukkit.getPluginManager().getPlugin("Essentials");
            if (essentialsPlugin == null) {
                essentialsPlugin = Bukkit.getPluginManager().getPlugin("EssentialsX");
            }
            if (essentialsPlugin != null && (iEssentialsClass = Class.forName("net.ess3.api.IEssentials")).isInstance(essentialsPlugin)) {
                essentialsAPI = essentialsPlugin;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            essentialsAPI = null;
        }
        catch (Exception e) {
            essentialsAPI = null;
        }
    }

    private static boolean isEssentialsAvailable() {
        GodmodeFlagHandler.initEssentialsAPI();
        return essentialsAPI != null;
    }

    protected GodmodeFlagHandler(Session session) {
        super(session, (Flag)Flags.GODMODE);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, StateFlag.State value) {
        this.handleValue(player, value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, null);
        return true;
    }

    private void handleValue(LocalPlayer player, StateFlag.State state) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (bukkitPlayer == null || !bukkitPlayer.isOnline()) {
            return;
        }
        UUID playerUUID = bukkitPlayer.getUniqueId();
        boolean hadEssentialsGodmode = false;
        boolean hadWorldGuardGodmode = false;
        if (state == StateFlag.State.DENY) {
            try {
                Session session = this.getSession();
                if (session != null) {
                    Method hasGodModeMethod;
                    Boolean hasGodMode;
                    Class<?> godModeClass = Class.forName("com.sk89q.worldguard.session.handler.GodMode");
                    Method getHandlerMethod = session.getClass().getMethod("getHandler", Class.class);
                    Object godModeHandler = getHandlerMethod.invoke((Object)session, godModeClass);
                    if (godModeHandler != null && (hasGodMode = (Boolean)(hasGodModeMethod = godModeClass.getMethod("hasGodMode", LocalPlayer.class)).invoke(godModeHandler, player)) != null && hasGodMode.booleanValue()) {
                        if (!originalWorldGuardGodmodeCache.containsKey(playerUUID)) {
                            originalWorldGuardGodmodeCache.put(playerUUID, true);
                        }
                        Method setGodModeMethod = godModeClass.getMethod("set", LocalPlayer.class, Session.class, Boolean.TYPE);
                        setGodModeMethod.invoke(null, player, session, false);
                        hadWorldGuardGodmode = true;
                    }
                }
            }
            catch (Exception session) {
                // empty catch block
            }
            if (GodmodeFlagHandler.isEssentialsAvailable() && essentialsAPI != null) {
                try {
                    Method isGodModeEnabledMethod;
                    Boolean essentialsGodmodeEnabled;
                    Class<?> userClass;
                    Class<?> iEssentialsClass = Class.forName("net.ess3.api.IEssentials");
                    Method getUserMethod = iEssentialsClass.getMethod("getUser", Player.class);
                    Object essentialsUser = getUserMethod.invoke(essentialsAPI, bukkitPlayer);
                    if (essentialsUser != null && (userClass = Class.forName("com.earth2me.essentials.User")).isInstance(essentialsUser) && (essentialsGodmodeEnabled = (Boolean)(isGodModeEnabledMethod = userClass.getMethod("isGodModeEnabled", new Class[0])).invoke(essentialsUser, new Object[0])) != null && essentialsGodmodeEnabled.booleanValue()) {
                        if (!originalEssentialsGodmodeCache.containsKey(playerUUID)) {
                            originalEssentialsGodmodeCache.put(playerUUID, true);
                        }
                        Method setGodModeEnabledMethod = userClass.getMethod("setGodModeEnabled", Boolean.TYPE);
                        setGodModeEnabledMethod.invoke(essentialsUser, false);
                        hadEssentialsGodmode = true;
                    }
                }
                catch (Exception iEssentialsClass) {
                    // empty catch block
                }
            }
            if (hadEssentialsGodmode || hadWorldGuardGodmode) {
                this.sendGodmodeDisabledMessage(bukkitPlayer);
            }
        } else if (state == null) {
            boolean autoRestore = this.getAutoGiveGodmodeRegionLeft();
            if (autoRestore) {
                Boolean cachedEssentialsGodmode;
                Boolean cachedWorldGuardGodmode = originalWorldGuardGodmodeCache.get(playerUUID);
                if (cachedWorldGuardGodmode != null && cachedWorldGuardGodmode.booleanValue()) {
                    try {
                        Session session = this.getSession();
                        if (session != null) {
                            Class<?> godModeClass = Class.forName("com.sk89q.worldguard.session.handler.GodMode");
                            Method setGodModeMethod = godModeClass.getMethod("set", LocalPlayer.class, Session.class, Boolean.TYPE);
                            setGodModeMethod.invoke(null, player, session, true);
                        }
                    }
                    catch (Exception session) {
                        // empty catch block
                    }
                }
                if ((cachedEssentialsGodmode = originalEssentialsGodmodeCache.get(playerUUID)) != null && cachedEssentialsGodmode.booleanValue() && GodmodeFlagHandler.isEssentialsAvailable() && essentialsAPI != null) {
                    try {
                        Class<?> userClass;
                        Class<?> iEssentialsClass = Class.forName("net.ess3.api.IEssentials");
                        Method getUserMethod = iEssentialsClass.getMethod("getUser", Player.class);
                        Object essentialsUser = getUserMethod.invoke(essentialsAPI, bukkitPlayer);
                        if (essentialsUser != null && (userClass = Class.forName("com.earth2me.essentials.User")).isInstance(essentialsUser)) {
                            Method setGodModeEnabledMethod = userClass.getMethod("setGodModeEnabled", Boolean.TYPE);
                            setGodModeEnabledMethod.invoke(essentialsUser, true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            originalWorldGuardGodmodeCache.remove(playerUUID);
            originalEssentialsGodmodeCache.remove(playerUUID);
        }
    }

    private boolean getAutoGiveGodmodeRegionLeft() {
        try {
            Class<?> configClass = Class.forName("dev.tins.worldguardextraflagsplus.Config");
            Method getMethod = configClass.getMethod("isAutoGiveGodmodeRegionLeft", new Class[0]);
            return (Boolean)getMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void sendGodmodeDisabledMessage(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)player, task -> {
            Player onlinePlayer = Bukkit.getPlayer((UUID)player.getUniqueId());
            if (onlinePlayer != null && onlinePlayer.isOnline()) {
                try {
                    Class<?> messagesClass = Class.forName("dev.tins.worldguardextraflagsplus.Messages");
                    Method sendMessageMethod = messagesClass.getMethod("sendMessageWithCooldown", Player.class, String.class, String[].class);
                    sendMessageMethod.invoke(null, onlinePlayer, "godmode-disabled", new String[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public StateFlag.State getInvincibility(LocalPlayer player) {
        return null;
    }

    static {
        essentialsChecked = false;
    }

    public static class Factory
    extends Handler.Factory<GodmodeFlagHandler> {
        public GodmodeFlagHandler create(Session session) {
            return new GodmodeFlagHandler(session);
        }
    }
}

