/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.flags.helpers.ForcedStateFlag;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class GlideFlagHandler
extends FlagValueChangeHandler<ForcedStateFlag.ForcedState> {
    private Boolean originalGlide;

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected GlideFlagHandler(Session session) {
        super(session, (Flag)Flags.GLIDE);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, ForcedStateFlag.ForcedState value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, ForcedStateFlag.ForcedState currentValue, ForcedStateFlag.ForcedState lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, ForcedStateFlag.ForcedState lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    private void handleValue(LocalPlayer player, World world, ForcedStateFlag.ForcedState state) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            if (!this.getSession().getManager().hasBypass(player, world) && state != null) {
                if (state != ForcedStateFlag.ForcedState.ALLOW) {
                    boolean value;
                    boolean bl = value = state == ForcedStateFlag.ForcedState.FORCE;
                    if (bukkitPlayer.isGliding() != value) {
                        if (this.originalGlide == null) {
                            this.originalGlide = bukkitPlayer.isGliding();
                        }
                        bukkitPlayer.setGliding(value);
                    }
                }
            } else if (this.originalGlide != null) {
                bukkitPlayer.setGliding(this.originalGlide.booleanValue());
                this.originalGlide = null;
            }
        });
    }

    public static class Factory
    extends Handler.Factory<GlideFlagHandler> {
        public GlideFlagHandler create(Session session) {
            return new GlideFlagHandler(session);
        }
    }
}

