/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import lombok.Generated;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class FlyFlagHandler
extends FlagValueChangeHandler<StateFlag.State> {
    private Boolean currentValue;
    private Boolean originalFly;

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected FlyFlagHandler(Session session) {
        super(session, (Flag)Flags.FLY);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, StateFlag.State value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    private void handleValue(LocalPlayer player, World world, StateFlag.State state) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || !bukkitPlayer.isOnline()) {
            return;
        }
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            if (!this.getSession().getManager().hasBypass(player, world) && state != null) {
                boolean value;
                boolean bl = value = state == StateFlag.State.ALLOW;
                if (bukkitPlayer.getAllowFlight() != value) {
                    if (this.originalFly == null) {
                        this.originalFly = bukkitPlayer.getAllowFlight();
                    }
                    bukkitPlayer.setAllowFlight(value);
                }
                this.currentValue = value;
            } else {
                if (this.originalFly != null) {
                    bukkitPlayer.setAllowFlight(this.originalFly.booleanValue());
                    this.originalFly = null;
                }
                this.currentValue = null;
            }
        });
    }

    @Generated
    public Boolean getCurrentValue() {
        return this.currentValue;
    }

    @Generated
    public void setOriginalFly(Boolean originalFly) {
        this.originalFly = originalFly;
    }

    public static class Factory
    extends Handler.Factory<FlyFlagHandler> {
        public FlyFlagHandler create(Session session) {
            return new FlyFlagHandler(session);
        }
    }
}

