/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CommandOnExitFlagHandler
extends Handler {
    private Collection<Set<String>> lastCommands = new ArrayList<Set<String>>();

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected CommandOnExitFlagHandler(Session session) {
        super(session);
    }

    public void initialize(LocalPlayer player, Location current, ApplicableRegionSet set) {
        this.lastCommands = set.queryAllValues((RegionAssociable)player, Flags.COMMAND_ON_EXIT);
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        ArrayList commands = Lists.newArrayList((Iterable)toSet.queryAllValues((RegionAssociable)player, Flags.COMMAND_ON_EXIT));
        if (!commands.isEmpty()) {
            for (ProtectedRegion region : toSet) {
                Set commands_ = (Set)region.getFlag(Flags.COMMAND_ON_EXIT);
                if (commands_ == null) continue;
                commands.add(commands_);
            }
        }
        Collection<Set<String>> lastCommands = this.lastCommands;
        this.lastCommands = commands;
        if (!this.getSession().getManager().hasBypass(player, (World)to.getExtent())) {
            Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
            for (Set<String> commands_ : lastCommands) {
                if (commands.contains(commands_) || commands_.size() <= 0) continue;
                for (String command : commands_) {
                    String processedCommand = command.substring(1).replace("%username%", player.getName()).replace("%player%", player.getName()).replace("{player}", player.getName()).replace("{username}", player.getName());
                    WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, wrappedTask -> Bukkit.getServer().dispatchCommand((CommandSender)bukkitPlayer, processedCommand));
                }
            }
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<CommandOnExitFlagHandler> {
        public CommandOnExitFlagHandler create(Session session) {
            return new CommandOnExitFlagHandler(session);
        }
    }
}

