/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg.handlers;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import java.lang.reflect.Method;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CollisionFlagHandler
extends FlagValueChangeHandler<Boolean> {
    private Boolean currentValue;

    public static final Factory FACTORY() {
        return new Factory();
    }

    protected CollisionFlagHandler(Session session) {
        super(session, (Flag)Flags.DISABLE_COLLISION);
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, Boolean value) {
        this.handleValue(player, player.getWorld(), value);
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Boolean currentValue, Boolean lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), currentValue);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Boolean lastValue, MoveType moveType) {
        this.handleValue(player, (World)to.getExtent(), null);
        return true;
    }

    private void handleValue(LocalPlayer player, World world, Boolean disableCollision) {
        Player bukkitPlayer = ((BukkitPlayer)player).getPlayer();
        if (!WorldGuardUtils.isPluginEnabled() || bukkitPlayer == null || !bukkitPlayer.isOnline()) {
            return;
        }
        if (this.getSession().getManager().hasBypass(player, world)) {
            WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
                Player onlinePlayer = Bukkit.getPlayer((UUID)bukkitPlayer.getUniqueId());
                if (onlinePlayer != null && onlinePlayer.isOnline()) {
                    this.applyCollisionSetting(onlinePlayer, false);
                }
            });
            return;
        }
        this.currentValue = disableCollision;
        UUID playerUUID = bukkitPlayer.getUniqueId();
        WorldGuardUtils.getScheduler().runAtEntity((Entity)bukkitPlayer, task -> {
            Player onlinePlayer = Bukkit.getPlayer((UUID)playerUUID);
            if (onlinePlayer == null || !onlinePlayer.isOnline()) {
                return;
            }
            this.applyCollisionSetting(onlinePlayer, disableCollision);
        });
    }

    private void applyCollisionSetting(Player player, Boolean disableCollision) {
        if (player == null || !player.isOnline()) {
            return;
        }
        try {
            Class<?> pluginClass = Class.forName("dev.tins.worldguardextraflagsplus.WorldGuardExtraFlagsPlusPlugin");
            Method getPluginMethod = pluginClass.getMethod("getPlugin", new Class[0]);
            Object plugin = getPluginMethod.invoke(null, new Object[0]);
            if (plugin == null) {
                Bukkit.getLogger().warning("[Collision] Plugin instance is null!");
                return;
            }
            Method getPacketHandlerMethod = pluginClass.getMethod("getCollisionPacketHandler", new Class[0]);
            Object packetHandler = getPacketHandlerMethod.invoke(plugin, new Object[0]);
            if (packetHandler == null) {
                Bukkit.getLogger().warning("[Collision] Packet handler is null - collision feature is disabled");
                return;
            }
            Class<?> handlerClass = packetHandler.getClass();
            if (disableCollision != null && disableCollision.booleanValue()) {
                Method disableMethod = handlerClass.getMethod("disableCollision", Player.class);
                disableMethod.invoke(packetHandler, player);
            } else {
                Method enableMethod = handlerClass.getMethod("enableCollision", Player.class);
                enableMethod.invoke(packetHandler, player);
            }
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().warning("[Collision] Plugin class not found - Spigot module not loaded: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Bukkit.getLogger().warning("[Collision] Method not found - API mismatch: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[Collision] Failed to apply collision setting: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
            e.printStackTrace();
        }
    }

    public void applyCollisionSettingPublic(Player player, Boolean disableCollision) {
        if (player == null || !player.isOnline()) {
            return;
        }
        this.applyCollisionSetting(player, disableCollision);
    }

    @Generated
    public Boolean getCurrentValue() {
        return this.currentValue;
    }

    public static class Factory
    extends Handler.Factory<CollisionFlagHandler> {
        public CollisionFlagHandler create(Session session) {
            return new CollisionFlagHandler(session);
        }
    }
}

