/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.wg;

import dev.tins.worldguardextraflagsplus.folialib.FoliaLib;
import dev.tins.worldguardextraflagsplus.folialib.impl.ServerImplementation;
import dev.tins.worldguardextraflagsplus.folialib.wrapper.task.WrappedTask;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class WorldGuardUtils {
    public static final String PREVENT_TELEPORT_LOOP_META = "WGEFP: TLP";
    private static FoliaLib foliaLib;
    private static SchedulerWrapper schedulerWrapper;
    private static Plugin plugin;

    public static void initializeScheduler(Plugin plugin) {
        foliaLib = new FoliaLib(plugin);
        schedulerWrapper = new SchedulerWrapper(foliaLib);
        WorldGuardUtils.plugin = plugin;
    }

    public static SchedulerWrapper getScheduler() {
        return schedulerWrapper;
    }

    public static boolean isPluginEnabled() {
        return plugin != null && plugin.isEnabled();
    }

    public static boolean hasNoTeleportLoop(Plugin plugin, Player player, Object location) {
        Set set;
        MetadataValue result = player.getMetadata(PREVENT_TELEPORT_LOOP_META).stream().filter(p -> p.getOwningPlugin().equals((Object)plugin)).findFirst().orElse(null);
        if (result == null) {
            result = new FixedMetadataValue(plugin, new HashSet());
            player.setMetadata(PREVENT_TELEPORT_LOOP_META, result);
            if (schedulerWrapper != null && foliaLib != null) {
                schedulerWrapper.runAtEntity((Entity)player, wrappedTask -> player.removeMetadata(PREVENT_TELEPORT_LOOP_META, plugin));
            } else {
                plugin.getServer().getScheduler().runTask(plugin, () -> player.removeMetadata(PREVENT_TELEPORT_LOOP_META, plugin));
            }
        }
        return (set = (Set)result.value()).add(location);
    }

    public static class SchedulerWrapper {
        private final FoliaLib foliaLib;
        private final ServerImplementation scheduler;

        private SchedulerWrapper(FoliaLib foliaLib) {
            this.foliaLib = foliaLib;
            this.scheduler = foliaLib.getScheduler();
        }

        public FoliaLib getImpl() {
            return this.foliaLib;
        }

        public ServerImplementation getScheduler() {
            return this.scheduler;
        }

        public void runAtEntity(Entity entity, Consumer<WrappedTask> task) {
            this.scheduler.runAtEntity(entity, task);
        }

        public void runNextTick(Consumer<WrappedTask> task) {
            this.scheduler.runNextTick(task);
        }

        public WrappedTask runAtEntityTimer(Entity entity, Runnable runnable, long delayTicks, long periodTicks) {
            return this.scheduler.runAtEntityTimer(entity, runnable, delayTicks, periodTicks);
        }

        public WrappedTask runAtEntityTimer(Entity entity, Runnable runnable, long delay, long period, TimeUnit timeUnit) {
            return this.scheduler.runAtEntityTimer(entity, runnable, delay, period, timeUnit);
        }
    }
}

