/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.listeners;

import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import dev.tins.worldguardextraflagsplus.we.handlers.WorldEditFlagHandler;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;

public class WorldEditListener {
    private final WorldGuardPlugin worldGuardPlugin;
    private final RegionContainer regionContainer;
    private final SessionManager sessionManager;

    @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
    public void onEditSessionEvent(EditSessionEvent event) {
        World world = event.getWorld();
        RegionManager regionManager = this.regionContainer.get(world);
        if (regionManager == null) {
            return;
        }
        Actor actor = event.getActor();
        if (actor instanceof Player) {
            Player player = (Player)actor;
            LocalPlayer localPlayer = this.worldGuardPlugin.wrapPlayer(Bukkit.getPlayer((UUID)player.getUniqueId()));
            if (this.sessionManager.hasBypass(localPlayer, world)) {
                return;
            }
            event.setExtent((Extent)new WorldEditFlagHandler(world, event.getExtent(), localPlayer, regionManager));
        }
    }

    @Generated
    public WorldEditListener(WorldGuardPlugin worldGuardPlugin, RegionContainer regionContainer, SessionManager sessionManager) {
        this.worldGuardPlugin = worldGuardPlugin;
        this.regionContainer = regionContainer;
        this.sessionManager = sessionManager;
    }
}

