/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.flags.helpers;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import java.util.HashSet;
import java.util.Set;

public class BlockableItemFlag
extends Flag<String> {
    private static final Set<String> BLOCKABLE_ITEMS = new HashSet<String>();

    public BlockableItemFlag(String name) {
        super(name);
    }

    public Object marshal(String o) {
        return o;
    }

    public String parseInput(FlagContext context) throws InvalidFlagFormat {
        String input = context.getUserInput().trim();
        if (input.isEmpty()) {
            throw new InvalidFlagFormat("Item name cannot be empty");
        }
        String upperInput = input.toUpperCase();
        if (!BLOCKABLE_ITEMS.contains(upperInput)) {
            throw new InvalidFlagFormat("Invalid item '" + input + "'. Only the following items can be blocked: " + String.join((CharSequence)", ", BLOCKABLE_ITEMS));
        }
        return upperInput;
    }

    public String unmarshal(Object o) {
        String item;
        if (o instanceof String && BLOCKABLE_ITEMS.contains(item = ((String)o).toUpperCase())) {
            return item;
        }
        return null;
    }

    public static Set<String> getBlockableItems() {
        return new HashSet<String>(BLOCKABLE_ITEMS);
    }

    static {
        BLOCKABLE_ITEMS.add("MACE");
        BLOCKABLE_ITEMS.add("FIREWORK_ROCKET");
        BLOCKABLE_ITEMS.add("WIND_CHARGE");
        BLOCKABLE_ITEMS.add("TOTEM_OF_UNDYING");
        BLOCKABLE_ITEMS.add("TRIDENT");
    }
}

