/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.config;

import dev.tins.worldguardextraflagsplus.configlib.Comment;
import dev.tins.worldguardextraflagsplus.configlib.Configuration;
import lombok.Generated;

@Configuration
public final class PluginMessages {
    public static final String MESSAGES_HEADER = "WorldGuardExtraFlagsPlus Messages Configuration\nThis file is located in the WorldGuard plugin folder\nYou can customize all messages shown to players here\n\nIMPORTANT: Empty String = Disabled Message\nIf you set a message to \"\" (empty string), that message will be disabled\nand no message will be sent to the player. This is useful if you want to\nsilence certain messages while keeping others active.\n\nExample:\n  disable-completely-blocked: \"\"  # This will disable the blocked item message\n\nMessages are cached on plugin load for better performance.\nUse /wg reload or /wgefp reload (or /wgefplus reload or /worldguardextraflagsplus reload) to reload messages without restarting the server.\n\nPlaceholders:\n  {required} - The required level/threshold value\n  {current}  - The player's current level/value\n  {item}     - The item name that was blocked\n\nMessage Cooldown:\n  Prevents message spam by adding a cooldown between messages sent to the same player.\n  Set to 0 to disable cooldown (messages will always be sent).\n  Default: 3 seconds\n";
    @Comment(value={"Message cooldown in seconds", "Prevents message spam by adding a cooldown between messages sent to the same player", "Set to 0 to disable cooldown (messages will always be sent)", "Default: 3 seconds"})
    private int sendMessageCooldown = 3;
    @Comment(value={"Entry level flags messages"})
    private String entryMinLevelDenied = "&cYour level (&7{current}&c) is low to enter this area. &7Min: &8{required}";
    @Comment(value={"Entry level flags messages"})
    private String entryMaxLevelDenied = "&cYour level (&7{current}&c) is so high to enter this area. &7Max: &8{required}";
    @Comment(value={"Disable completely flag message"})
    private String disableCompletelyBlocked = "&cHey! &7You can not use {item} in here!";
    @Comment(value={"Permit workbenches flag message"})
    private String permitWorkbenchesBlocked = "&cHey! &7You can not use {workbench} in here!";
    @Comment(value={"Inventory craft flag message"})
    private String inventoryCraftBlocked = "&cHey! &7You can not craft items in your inventory here!";
    @Comment(value={"Godmode disabled message (extra plugins and worldguard)"})
    private String godmodeDisabled = "&cHey! &7Godmode disabled in this region!";

    @Generated
    public int getSendMessageCooldown() {
        return this.sendMessageCooldown;
    }

    @Generated
    public String getEntryMinLevelDenied() {
        return this.entryMinLevelDenied;
    }

    @Generated
    public String getEntryMaxLevelDenied() {
        return this.entryMaxLevelDenied;
    }

    @Generated
    public String getDisableCompletelyBlocked() {
        return this.disableCompletelyBlocked;
    }

    @Generated
    public String getPermitWorkbenchesBlocked() {
        return this.permitWorkbenchesBlocked;
    }

    @Generated
    public String getInventoryCraftBlocked() {
        return this.inventoryCraftBlocked;
    }

    @Generated
    public String getGodmodeDisabled() {
        return this.godmodeDisabled;
    }

    @Generated
    public PluginMessages() {
    }
}

