/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.commands;

import dev.tins.worldguardextraflagsplus.Config;
import dev.tins.worldguardextraflagsplus.Messages;
import dev.tins.worldguardextraflagsplus.WorldGuardExtraFlagsPlusPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ReloadCommand
implements CommandExecutor,
TabCompleter {
    private final WorldGuardExtraFlagsPlusPlugin plugin;

    public ReloadCommand(WorldGuardExtraFlagsPlusPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /" + label + " reload");
            return true;
        }
        if (!args[0].equalsIgnoreCase("reload")) {
            sender.sendMessage("\u00a7cUnknown subcommand: " + args[0]);
            sender.sendMessage("\u00a7eUsage: /" + label + " reload");
            return true;
        }
        if (!sender.hasPermission("worldguardextraflagsplus.reload")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        try {
            Messages.reloadMessages();
            Config.reloadConfig();
            sender.sendMessage("\u00a7aMessages and config reloaded successfully!");
            this.plugin.getLogger().info("Messages and config reloaded by " + sender.getName());
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to reload messages/config: " + e.getMessage());
            this.plugin.getLogger().log(Level.SEVERE, "Failed to reload messages/config", e);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

