/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.collision;

import dev.tins.worldguardextraflagsplus.WorldGuardExtraFlagsPlusPlugin;
import dev.tins.worldguardextraflagsplus.collision.CollisionPacketHandler;
import dev.tins.worldguardextraflagsplus.collision.TabIntegration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class TeamCollisionHandler
implements CollisionPacketHandler {
    private static final String TEAM_NAME_PREFIX = "WGC_";
    private final WorldGuardExtraFlagsPlusPlugin plugin;
    private final Set<UUID> collisionDisabledPlayers = Collections.synchronizedSet(new HashSet());
    private final Map<UUID, Team.OptionStatus> originalCollisionRules = new HashMap<UUID, Team.OptionStatus>();
    private final Map<UUID, Team> modifiedTeams = new HashMap<UUID, Team>();
    private final Map<UUID, Team> perPlayerTeams = new HashMap<UUID, Team>();

    public TeamCollisionHandler(WorldGuardExtraFlagsPlusPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        try {
            if (TabIntegration.initialize()) {
                this.plugin.getLogger().info("[Collision] TAB integration initialized - using TAB API for collision management");
                return true;
            }
            ScoreboardManager manager = this.plugin.getServer().getScoreboardManager();
            if (manager == null) {
                this.plugin.getLogger().warning("[Collision] ScoreboardManager is null!");
                return false;
            }
            Scoreboard scoreboard = manager.getMainScoreboard();
            if (scoreboard == null) {
                this.plugin.getLogger().warning("[Collision] Main scoreboard is null!");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Collision] Failed to initialize collision handler: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void disableCollision(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (TabIntegration.isAvailable() && TabIntegration.setCollisionRule(player, true)) {
            this.collisionDisabledPlayers.add(player.getUniqueId());
            return;
        }
        try {
            Scoreboard scoreboard = player.getScoreboard();
            Team currentTeam = scoreboard.getPlayerTeam((OfflinePlayer)player);
            if (currentTeam != null) {
                int teamSize = currentTeam.getEntries().size();
                if (teamSize == 1) {
                    Team.OptionStatus currentRule = currentTeam.getOption(Team.Option.COLLISION_RULE);
                    this.originalCollisionRules.put(player.getUniqueId(), currentRule);
                    this.modifiedTeams.put(player.getUniqueId(), currentTeam);
                    currentTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                    this.collisionDisabledPlayers.add(player.getUniqueId());
                } else {
                    String perPlayerTeamName = TEAM_NAME_PREFIX + Integer.toHexString(player.getUniqueId().hashCode());
                    Team perPlayerTeam = scoreboard.getTeam(perPlayerTeamName);
                    if (perPlayerTeam == null) {
                        perPlayerTeam = scoreboard.registerNewTeam(perPlayerTeamName);
                        perPlayerTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                    }
                    currentTeam.removeEntry(player.getName());
                    perPlayerTeam.addEntry(player.getName());
                    this.perPlayerTeams.put(player.getUniqueId(), perPlayerTeam);
                    this.modifiedTeams.put(player.getUniqueId(), currentTeam);
                    this.collisionDisabledPlayers.add(player.getUniqueId());
                }
            } else {
                String perPlayerTeamName = TEAM_NAME_PREFIX + Integer.toHexString(player.getUniqueId().hashCode());
                Team perPlayerTeam = scoreboard.getTeam(perPlayerTeamName);
                if (perPlayerTeam == null) {
                    perPlayerTeam = scoreboard.registerNewTeam(perPlayerTeamName);
                    perPlayerTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                }
                perPlayerTeam.addEntry(player.getName());
                this.perPlayerTeams.put(player.getUniqueId(), perPlayerTeam);
                this.collisionDisabledPlayers.add(player.getUniqueId());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Collision] Failed to disable collision for " + player.getName() + ": " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
            e.printStackTrace();
        }
    }

    @Override
    public void enableCollision(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (TabIntegration.isAvailable() && TabIntegration.setCollisionRule(player, null)) {
            this.collisionDisabledPlayers.remove(playerUUID);
            return;
        }
        try {
            Scoreboard scoreboard = player.getScoreboard();
            if (this.perPlayerTeams.containsKey(playerUUID)) {
                Team perPlayerTeam = this.perPlayerTeams.remove(playerUUID);
                Team originalTeam = this.modifiedTeams.remove(playerUUID);
                perPlayerTeam.removeEntry(player.getName());
                if (originalTeam != null) {
                    originalTeam.addEntry(player.getName());
                }
            } else if (this.modifiedTeams.containsKey(playerUUID)) {
                Team team = this.modifiedTeams.remove(playerUUID);
                Team.OptionStatus originalRule = this.originalCollisionRules.remove(playerUUID);
                if (team != null && originalRule != null) {
                    team.setOption(Team.Option.COLLISION_RULE, originalRule);
                }
            }
            Team currentTeam = scoreboard.getPlayerTeam((OfflinePlayer)player);
            if (currentTeam != null && this.collisionDisabledPlayers.contains(playerUUID)) {
                String teamName = currentTeam.getName();
                if (teamName.startsWith(TEAM_NAME_PREFIX)) {
                    currentTeam.removeEntry(player.getName());
                } else if (currentTeam.getOption(Team.Option.COLLISION_RULE) == Team.OptionStatus.NEVER) {
                    currentTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.ALWAYS);
                }
            }
            this.collisionDisabledPlayers.remove(playerUUID);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Collision] Failed to enable collision for " + player.getName() + ": " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
            e.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
        Team team2;
        for (Map.Entry<UUID, Team> entry : this.modifiedTeams.entrySet()) {
            try {
                team2 = entry.getValue();
                Team.OptionStatus originalRule = this.originalCollisionRules.get(entry.getKey());
                if (team2 == null || originalRule == null) continue;
                team2.setOption(Team.Option.COLLISION_RULE, originalRule);
            }
            catch (Exception team2) {}
        }
        for (Map.Entry<UUID, Team> entry : this.perPlayerTeams.entrySet()) {
            try {
                team2 = entry.getValue();
                HashSet entries = new HashSet(team2.getEntries());
                for (String teamEntry : entries) {
                    team2.removeEntry(teamEntry);
                }
                team2.unregister();
            }
            catch (Exception exception) {}
        }
        this.collisionDisabledPlayers.clear();
        this.originalCollisionRules.clear();
        this.modifiedTeams.clear();
        this.perPlayerTeams.clear();
    }

    @Override
    public String getLibraryName() {
        return "Native Teams";
    }
}

