/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus.collision;

import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabIntegration {
    private static final String TAB_PLUGIN_NAME = "TAB";
    private static Object tabApiInstance = null;
    private static Object nameTagManager = null;
    private static Method getPlayerMethod = null;
    private static Method setCollisionRuleMethod = null;
    private static boolean initialized = false;

    public static boolean initialize() {
        if (initialized) {
            return nameTagManager != null;
        }
        initialized = true;
        try {
            Plugin tabPlugin = Bukkit.getPluginManager().getPlugin(TAB_PLUGIN_NAME);
            if (tabPlugin == null) {
                return false;
            }
            Class<?> tabApiClass = Class.forName("me.neznamy.tab.api.TabAPI");
            Method getInstanceMethod = tabApiClass.getMethod("getInstance", new Class[0]);
            tabApiInstance = getInstanceMethod.invoke(null, new Object[0]);
            if (tabApiInstance == null) {
                return false;
            }
            Method getNameTagManagerMethod = tabApiClass.getMethod("getNameTagManager", new Class[0]);
            nameTagManager = getNameTagManagerMethod.invoke(tabApiInstance, new Object[0]);
            if (nameTagManager == null) {
                return false;
            }
            Class<?> nameTagManagerClass = nameTagManager.getClass().getInterfaces()[0];
            setCollisionRuleMethod = nameTagManagerClass.getMethod("setCollisionRule", Class.forName("me.neznamy.tab.api.TabPlayer"), Boolean.class);
            getPlayerMethod = tabApiClass.getMethod("getPlayer", UUID.class);
            return true;
        }
        catch (Exception e) {
            tabApiInstance = null;
            nameTagManager = null;
            return false;
        }
    }

    public static boolean isAvailable() {
        return initialized && nameTagManager != null;
    }

    public static boolean setCollisionRule(Player player, Boolean collision) {
        if (!TabIntegration.isAvailable() || player == null) {
            return false;
        }
        try {
            Object tabPlayer = getPlayerMethod.invoke(tabApiInstance, player.getUniqueId());
            if (tabPlayer == null) {
                return false;
            }
            Boolean tabCollision = collision == null ? null : Boolean.valueOf(collision == false);
            setCollisionRuleMethod.invoke(nameTagManager, tabPlayer, tabCollision);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

