/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import dev.tins.worldguardextraflagsplus.Config;
import dev.tins.worldguardextraflagsplus.Messages;
import dev.tins.worldguardextraflagsplus.bstats.bukkit.Metrics;
import dev.tins.worldguardextraflagsplus.collision.CollisionPacketHandler;
import dev.tins.worldguardextraflagsplus.collision.TeamCollisionHandler;
import dev.tins.worldguardextraflagsplus.commands.ReloadCommand;
import dev.tins.worldguardextraflagsplus.flags.Flags;
import dev.tins.worldguardextraflagsplus.listeners.BlockListener;
import dev.tins.worldguardextraflagsplus.listeners.EntityListener;
import dev.tins.worldguardextraflagsplus.listeners.EntityPotionEffectEventListener;
import dev.tins.worldguardextraflagsplus.listeners.PlayerListener;
import dev.tins.worldguardextraflagsplus.listeners.VillagerTradeListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldEditListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldGuardReloadListener;
import dev.tins.worldguardextraflagsplus.listeners.WorldListener;
import dev.tins.worldguardextraflagsplus.protocollib.ProtocolLibHelper;
import dev.tins.worldguardextraflagsplus.updater.UpdateChecker;
import dev.tins.worldguardextraflagsplus.wg.WorldGuardUtils;
import dev.tins.worldguardextraflagsplus.wg.handlers.BlockedEffectsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CollisionFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CommandOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.CommandOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.ConsoleCommandOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.ConsoleCommandOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.EntryLevelFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.FlyFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.FlySpeedFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GiveEffectsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GlideFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.GodmodeFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.PlaySoundsFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.TeleportOnEntryFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.TeleportOnExitFlagHandler;
import dev.tins.worldguardextraflagsplus.wg.handlers.WalkSpeedFlagHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class WorldGuardExtraFlagsPlusPlugin
extends JavaPlugin {
    private static final Set<Flag<?>> FLAGS = WorldGuardExtraFlagsPlusPlugin.getPluginFlags();
    private static WorldGuardExtraFlagsPlusPlugin plugin;
    private WorldEditPlugin worldEditPlugin;
    private WorldGuardPlugin worldGuardPlugin;
    private WorldGuard worldGuard;
    private RegionContainer regionContainer;
    private SessionManager sessionManager;
    private ProtocolLibHelper protocolLibHelper;
    private boolean collisionFlagEnabled = false;
    private CollisionPacketHandler collisionPacketHandler = null;

    public WorldGuardExtraFlagsPlusPlugin() {
        plugin = this;
    }

    public void onLoad() {
        this.worldEditPlugin = (WorldEditPlugin)this.getServer().getPluginManager().getPlugin("WorldEdit");
        this.worldGuardPlugin = (WorldGuardPlugin)this.getServer().getPluginManager().getPlugin("WorldGuard");
        this.worldGuard = WorldGuard.getInstance();
        this.collisionFlagEnabled = true;
        Plugin protocolLibPlugin = this.getServer().getPluginManager().getPlugin("ProtocolLib");
        try {
            FlagRegistry flagRegistry = this.worldGuard.getFlagRegistry();
            flagRegistry.register((Flag)Flags.TELEPORT_ON_ENTRY);
            flagRegistry.register((Flag)Flags.TELEPORT_ON_EXIT);
            flagRegistry.register(Flags.COMMAND_ON_ENTRY);
            flagRegistry.register(Flags.COMMAND_ON_EXIT);
            flagRegistry.register(Flags.CONSOLE_COMMAND_ON_ENTRY);
            flagRegistry.register(Flags.CONSOLE_COMMAND_ON_EXIT);
            flagRegistry.register((Flag)Flags.WALK_SPEED);
            flagRegistry.register((Flag)Flags.KEEP_INVENTORY);
            flagRegistry.register((Flag)Flags.KEEP_EXP);
            flagRegistry.register((Flag)Flags.CHAT_PREFIX);
            flagRegistry.register((Flag)Flags.CHAT_SUFFIX);
            flagRegistry.register(Flags.BLOCKED_EFFECTS);
            flagRegistry.register((Flag)Flags.GODMODE);
            flagRegistry.register((Flag)Flags.RESPAWN_LOCATION);
            flagRegistry.register((Flag)Flags.WORLDEDIT);
            flagRegistry.register(Flags.GIVE_EFFECTS);
            flagRegistry.register((Flag)Flags.FLY);
            flagRegistry.register((Flag)Flags.FLY_SPEED);
            flagRegistry.register(Flags.PLAY_SOUNDS);
            flagRegistry.register((Flag)Flags.FROSTWALKER);
            flagRegistry.register((Flag)Flags.NETHER_PORTALS);
            flagRegistry.register(Flags.ALLOW_BLOCK_PLACE);
            flagRegistry.register(Flags.DENY_BLOCK_PLACE);
            flagRegistry.register(Flags.ALLOW_BLOCK_BREAK);
            flagRegistry.register(Flags.DENY_BLOCK_BREAK);
            flagRegistry.register(Flags.DENY_ITEM_DROPS);
            flagRegistry.register(Flags.DENY_ITEM_PICKUP);
            flagRegistry.register((Flag)Flags.GLIDE);
            flagRegistry.register((Flag)Flags.CHUNK_UNLOAD);
            flagRegistry.register((Flag)Flags.ITEM_DURABILITY);
            flagRegistry.register((Flag)Flags.JOIN_LOCATION);
            flagRegistry.register(Flags.DISABLE_COMPLETELY);
            flagRegistry.register(Flags.PERMIT_WORKBENCHES);
            flagRegistry.register(Flags.ENTRY_MIN_LEVEL);
            flagRegistry.register(Flags.ENTRY_MAX_LEVEL);
            flagRegistry.register((Flag)Flags.VILLAGER_TRADE);
            flagRegistry.register((Flag)Flags.INVENTORY_CRAFT);
            flagRegistry.register((Flag)Flags.DISABLE_COLLISION);
        }
        catch (Exception e) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            throw new RuntimeException(e instanceof IllegalStateException ? "WorldGuard prevented flag registration. Did you reload the plugin? This is not supported!" : "Flag registration failed!", e);
        }
        try {
            if (protocolLibPlugin != null) {
                this.protocolLibHelper = new ProtocolLibHelper(this, protocolLibPlugin);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onEnable() {
        block14: {
            Messages.initialize(this);
            Config.initialize(this);
            Set<String> migratedWorlds = this.migrateRegionFiles();
            WorldGuardUtils.initializeScheduler((Plugin)this);
            WorldGuardUtils.getScheduler().runNextTick(task -> this.cleanupOldCollisionTeam());
            this.regionContainer = this.worldGuard.getPlatform().getRegionContainer();
            this.sessionManager = this.worldGuard.getPlatform().getSessionManager();
            if (!migratedWorlds.isEmpty()) {
                for (String worldName : migratedWorlds) {
                    this.updateInMemoryRegions(worldName);
                }
            }
            this.sessionManager.registerHandler((Handler.Factory)TeleportOnEntryFlagHandler.FACTORY((Plugin)plugin), null);
            this.sessionManager.registerHandler((Handler.Factory)TeleportOnExitFlagHandler.FACTORY((Plugin)plugin), null);
            this.sessionManager.registerHandler((Handler.Factory)WalkSpeedFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)FlySpeedFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)FlyFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)GlideFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)GodmodeFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)PlaySoundsFlagHandler.FACTORY((Plugin)plugin), null);
            this.sessionManager.registerHandler((Handler.Factory)BlockedEffectsFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)GiveEffectsFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)CommandOnEntryFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)CommandOnExitFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)ConsoleCommandOnEntryFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)ConsoleCommandOnExitFlagHandler.FACTORY(), null);
            this.sessionManager.registerHandler((Handler.Factory)EntryLevelFlagHandler.FACTORY((Plugin)plugin), null);
            try {
                boolean tabInstalled = this.getServer().getPluginManager().getPlugin("TAB") != null;
                this.getLogger().warning("[Collision Flag] The disable-collision flag uses Minecraft teams.");
                this.getLogger().warning("[Collision Flag] Using this flag with plugins that manage teams may cause conflicts!");
                this.getLogger().warning("[Collision Flag] Do NOT use the disable-collision flag if you have these plugins installed.");
                this.getLogger().warning("[Collision Flag] Supported plugins with (1): TAB");
                if (this.getServer().getScoreboardManager() == null || this.getServer().getScoreboardManager().getMainScoreboard() == null) {
                    this.collisionFlagEnabled = false;
                    this.getLogger().warning("[Collision Flag] Scoreboard not available - collision feature will be disabled");
                    break block14;
                }
                try {
                    this.collisionPacketHandler = new TeamCollisionHandler(this);
                    if (!this.collisionPacketHandler.initialize()) {
                        this.getLogger().warning("[Collision Flag] Failed to initialize collision handler");
                        this.getLogger().warning("[Collision Flag] Collision feature will be disabled");
                        this.collisionFlagEnabled = false;
                        this.collisionPacketHandler = null;
                        break block14;
                    }
                    this.getLogger().info("[Collision Flag] Initialized " + this.collisionPacketHandler.getLibraryName() + " collision handler");
                    this.sessionManager.registerHandler((Handler.Factory)CollisionFlagHandler.FACTORY(), null);
                }
                catch (Throwable e) {
                    this.getLogger().warning("[Collision Flag] Failed to register collision handler: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
                    this.getLogger().warning("[Collision Flag] Collision feature will be disabled");
                    this.collisionFlagEnabled = false;
                    if (this.collisionPacketHandler != null) {
                        this.collisionPacketHandler.cleanup();
                        this.collisionPacketHandler = null;
                    }
                }
            }
            catch (Exception e) {
                this.collisionFlagEnabled = false;
                this.getLogger().warning("[Collision Flag] Failed to check scoreboard availability: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
                this.getLogger().warning("[Collision Flag] Collision feature will be disabled");
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this, this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this, this.regionContainer), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerTradeListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldGuardReloadListener(this), (Plugin)this);
        this.worldEditPlugin.getWorldEdit().getEventBus().register((Object)new WorldEditListener(this.worldGuardPlugin, this.regionContainer, this.sessionManager));
        if (this.protocolLibHelper != null) {
            try {
                this.protocolLibHelper.onEnable();
            }
            catch (Throwable ignore) {
                this.getServer().getPluginManager().registerEvents((Listener)new EntityPotionEffectEventListener(this.worldGuardPlugin, this.sessionManager), (Plugin)this);
            }
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new EntityPotionEffectEventListener(this.worldGuardPlugin, this.sessionManager), (Plugin)this);
        }
        for (World world : this.getServer().getWorlds()) {
            this.doUnloadChunkFlagCheck(world);
        }
        this.setupMetrics();
        this.setupUpdateChecker();
        this.getCommand("wgefp").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("wgefp").setTabCompleter((TabCompleter)new ReloadCommand(this));
    }

    public void doUnloadChunkFlagCheck(World world) {
        RegionManager regionManager = this.regionContainer.get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return;
        }
        for (ProtectedRegion region : regionManager.getRegions().values()) {
            if (region.getFlag((Flag)Flags.CHUNK_UNLOAD) != StateFlag.State.DENY) continue;
            this.getLogger().info("Loading chunks for region " + region.getId() + " located in " + world.getName() + " due to chunk-unload flag being deny");
            BlockVector3 min = region.getMinimumPoint();
            BlockVector3 max = region.getMaximumPoint();
            for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
                for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                    world.getChunkAt(x, z).addPluginChunkTicket((Plugin)this);
                }
            }
        }
    }

    private Set<String> migrateRegionFiles() {
        HashSet<String> migratedWorlds = new HashSet<String>();
        try {
            File worldGuardDataFolder = this.worldGuardPlugin.getDataFolder();
            File worldsFolder = new File(worldGuardDataFolder, "worlds");
            if (!worldsFolder.exists() || !worldsFolder.isDirectory()) {
                return migratedWorlds;
            }
            int migratedCount = 0;
            File[] worldFolders = worldsFolder.listFiles(File::isDirectory);
            if (worldFolders == null) {
                return migratedWorlds;
            }
            for (File worldFolder : worldFolders) {
                File regionsFile = new File(worldFolder, "regions.yml");
                if (!regionsFile.exists() || !regionsFile.isFile()) continue;
                try {
                    String fileContent;
                    String originalContent = fileContent = new String(Files.readAllBytes(regionsFile.toPath()), StandardCharsets.UTF_8);
                    fileContent = fileContent.replaceAll("(?m)^(\\s*)permit-completely\\s*:", "$1disable-completely:");
                    if (fileContent.equals(originalContent)) continue;
                    Files.write(regionsFile.toPath(), fileContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
                    int occurrences = (originalContent.length() - originalContent.replace("permit-completely:", "").length()) / "permit-completely:".length();
                    migratedCount += occurrences;
                    this.getLogger().info("Migrated flag 'permit-completely' to 'disable-completely' in region file for world '" + worldFolder.getName() + "' (" + occurrences + " occurrence(s))");
                    migratedWorlds.add(worldFolder.getName());
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Failed to migrate region file for world '" + worldFolder.getName() + "': " + e.getMessage(), e);
                }
            }
            if (migratedCount > 0) {
                this.getLogger().info("Region file migration completed: " + migratedCount + " flag occurrence(s) migrated from 'permit-completely' to 'disable-completely'");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to migrate region files: " + e.getMessage(), e);
        }
        return migratedWorlds;
    }

    private void updateInMemoryRegions(String worldName) {
    }

    private void cleanupOldCollisionTeam() {
        try {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            if (scoreboard == null) {
                return;
            }
            Team team = scoreboard.getTeam("WGEFP_COLLISION_DISABLED");
            if (team != null) {
                HashSet entries = new HashSet(team.getEntries());
                for (String entry : entries) {
                    try {
                        team.removeEntry(entry);
                    }
                    catch (Exception exception) {}
                }
                try {
                    team.unregister();
                    this.getLogger().info("[Collision Flag] Cleaned up old collision team from previous implementation");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.getLogger().fine("[Collision Flag] Could not clean up old collision team: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
        }
    }

    private void setupMetrics() {
        int bStatsPluginId = 27821;
        try {
            Metrics metrics = new Metrics(this, 27821);
            this.getLogger().info("bStats metrics enabled (ID: 27821)");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to initialize bStats metrics: " + e.getMessage());
        }
    }

    private void setupUpdateChecker() {
        int spigotResourceId = 129946;
        String githubRepository = "tins-dev/WorldGuardExtraFlagsPlus";
        String modrinthProjectId = "worldguard-extraflags-plus";
        WorldGuardUtils.getScheduler().runNextTick(task -> WorldGuardUtils.getScheduler().runNextTick(delayedTask -> {
            UpdateChecker updateChecker = new UpdateChecker(this, spigotResourceId, githubRepository, modrinthProjectId);
            updateChecker.checkForUpdates();
        }));
    }

    public void onDisable() {
        if (this.collisionPacketHandler != null) {
            try {
                this.collisionPacketHandler.cleanup();
            }
            catch (Exception e) {
                this.getLogger().warning("[Collision Flag] Error during cleanup: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
            }
        }
    }

    private static Set<Flag<?>> getPluginFlags() {
        HashSet flags = new HashSet();
        for (Field field : Flags.class.getFields()) {
            try {
                flags.add((Flag)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return flags;
    }

    @Generated
    public static WorldGuardExtraFlagsPlusPlugin getPlugin() {
        return plugin;
    }

    @Generated
    public WorldEditPlugin getWorldEditPlugin() {
        return this.worldEditPlugin;
    }

    @Generated
    public WorldGuardPlugin getWorldGuardPlugin() {
        return this.worldGuardPlugin;
    }

    @Generated
    public WorldGuard getWorldGuard() {
        return this.worldGuard;
    }

    @Generated
    public RegionContainer getRegionContainer() {
        return this.regionContainer;
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Generated
    public ProtocolLibHelper getProtocolLibHelper() {
        return this.protocolLibHelper;
    }

    @Generated
    public boolean isCollisionFlagEnabled() {
        return this.collisionFlagEnabled;
    }

    @Generated
    public CollisionPacketHandler getCollisionPacketHandler() {
        return this.collisionPacketHandler;
    }
}

