/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import dev.tins.worldguardextraflagsplus.config.PluginMessages;
import dev.tins.worldguardextraflagsplus.configlib.ConfigurationException;
import dev.tins.worldguardextraflagsplus.configlib.NameFormatters;
import dev.tins.worldguardextraflagsplus.configlib.YamlConfigurationProperties;
import dev.tins.worldguardextraflagsplus.configlib.YamlConfigurations;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Messages {
    private static JavaPlugin plugin;
    private static PluginMessages messages;
    private static Path messagesFile;
    private static int messageCooldownSeconds;
    private static final ConcurrentHashMap<UUID, Long> messageCooldowns;
    private static final Map<String, String> messageMap;
    private static final YamlConfigurationProperties PROPERTIES;

    public static void initialize(JavaPlugin plugin) {
        Messages.plugin = plugin;
        File worldGuardDataFolder = plugin.getServer().getPluginManager().getPlugin("WorldGuard").getDataFolder();
        messagesFile = worldGuardDataFolder.toPath().resolve("messages-wgefp.yml");
        File oldMessagesFile = new File(worldGuardDataFolder, "messages.yml");
        if (oldMessagesFile.exists()) {
            try {
                YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldMessagesFile);
                if (oldConfig.contains("permit-completely-blocked")) {
                    if (oldMessagesFile.delete()) {
                        plugin.getLogger().info("Deleted old messages.yml file (migrated to messages-wgefp.yml)");
                    } else {
                        plugin.getLogger().warning("Failed to delete old messages.yml file. Please delete it manually.");
                    }
                }
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error checking old messages.yml file: " + e.getMessage(), e);
            }
        }
        Messages.reloadMessages();
    }

    public static void reloadMessages() {
        try {
            if (!messagesFile.getParent().toFile().exists()) {
                messagesFile.getParent().toFile().mkdirs();
            }
            if (messagesFile.toFile().exists()) {
                try {
                    String fileContent;
                    String originalContent = fileContent = new String(Files.readAllBytes(messagesFile), StandardCharsets.UTF_8);
                    if (fileContent.contains("permit-completely-blocked:") && !fileContent.contains("disable-completely-blocked:")) {
                        fileContent = fileContent.replaceAll("(?m)^(\\s*)#?\\s*permit-completely-blocked\\s*:", "$1disable-completely-blocked:");
                        fileContent = fileContent.replaceAll("(?m)^(\\s*)permit-completely-blocked\\s*:", "$1disable-completely-blocked:");
                        if (!(fileContent = fileContent.replaceAll("(?m)^(\\s*)#\\s*Permit completely flag message", "$1# Disable completely flag message")).equals(originalContent)) {
                            Files.write(messagesFile, fileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                            plugin.getLogger().info("Migrated 'permit-completely-blocked' to 'disable-completely-blocked' in messages-wgefp.yml");
                        }
                    }
                }
                catch (Exception e) {
                    plugin.getLogger().log(Level.WARNING, "Error during pre-migration: " + e.getMessage(), e);
                }
            }
            messages = YamlConfigurations.update(messagesFile, PluginMessages.class, PROPERTIES);
            Messages.fixLineWrapping(messagesFile);
            messages = YamlConfigurations.load(messagesFile, PluginMessages.class, PROPERTIES);
            Messages.buildMessageMap();
            messageCooldownSeconds = messages.getSendMessageCooldown();
            if (messageCooldownSeconds < 0) {
                messageCooldownSeconds = 0;
            }
            Messages.clearAllCooldowns();
            plugin.getLogger().info("Loaded messages from: " + String.valueOf(messagesFile.toAbsolutePath()));
            plugin.getLogger().info("Message cooldown: " + (String)(messageCooldownSeconds > 0 ? messageCooldownSeconds + " seconds" : "disabled"));
        }
        catch (ConfigurationException e) {
            Throwable cause = e.getCause();
            Object errorMsg = "Invalid YAML in messages-wgefp.yml";
            if (cause != null && cause.getClass().getSimpleName().equals("DuplicateKeyException")) {
                String message = cause.getMessage();
                if (message != null && message.contains("duplicate key")) {
                    int keyStart = message.indexOf("duplicate key");
                    if (keyStart != -1) {
                        String keyPart = message.substring(keyStart);
                        errorMsg = "Duplicate key found in messages-wgefp.yml: " + keyPart.split("\n")[0].replace("found duplicate key", "").trim();
                    } else {
                        errorMsg = "Duplicate key found in messages-wgefp.yml. Check the file for duplicate entries.";
                    }
                } else {
                    errorMsg = "Duplicate key found in messages-wgefp.yml. Check the file for duplicate entries.";
                }
            } else if (cause != null) {
                String causeMsg = cause.getMessage();
                if (causeMsg != null && causeMsg.contains("duplicate key")) {
                    errorMsg = "Duplicate key found in messages-wgefp.yml. Check the file for duplicate entries.";
                } else {
                    Object object = errorMsg = causeMsg != null ? causeMsg : cause.getClass().getSimpleName();
                    if (((String)errorMsg).length() > 100) {
                        errorMsg = ((String)errorMsg).substring(0, 100) + "...";
                    }
                }
            }
            plugin.getLogger().severe("CRITICAL: " + (String)errorMsg);
            plugin.getLogger().severe("File location: " + String.valueOf(messagesFile.toAbsolutePath()));
            plugin.getLogger().severe("Disabling plugin. Please fix the YAML file and restart the server.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            messages = new PluginMessages();
            Messages.buildMessageMap();
            messageCooldownSeconds = 3;
        }
        catch (Exception e) {
            Object errorMsg = e.getMessage();
            if (errorMsg != null && ((String)errorMsg).length() > 100) {
                errorMsg = ((String)errorMsg).substring(0, 100) + "...";
            }
            plugin.getLogger().severe("CRITICAL: Failed to load messages-wgefp.yml: " + (String)(errorMsg != null ? errorMsg : e.getClass().getSimpleName()));
            plugin.getLogger().severe("File location: " + String.valueOf(messagesFile.toAbsolutePath()));
            plugin.getLogger().severe("Disabling plugin. Please check the file and restart the server.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            messages = new PluginMessages();
            Messages.buildMessageMap();
            messageCooldownSeconds = 3;
        }
    }

    private static void buildMessageMap() {
        messageMap.clear();
        if (messages == null) {
            return;
        }
        try {
            Field[] fields;
            for (Field field : fields = PluginMessages.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().equals("sendMessageCooldown")) continue;
                field.setAccessible(true);
                Object value = field.get(messages);
                if (!(value instanceof String)) continue;
                String kebabKey = NameFormatters.LOWER_KEBAB_CASE.format(field.getName());
                messageMap.put(kebabKey, (String)value);
            }
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.WARNING, "Error building message map: " + e.getMessage(), e);
        }
    }

    public static String getMessage(String key, String ... replacements) {
        String message = messageMap.getOrDefault(key, "&cMessage not found: " + key);
        if (message == null || message.trim().isEmpty()) {
            return null;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String getRawMessage(String key) {
        return messageMap.getOrDefault(key, "");
    }

    public static boolean sendMessageWithCooldown(Player player, String key, String ... replacements) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        String message = Messages.getMessage(key, replacements);
        if (message == null) {
            return false;
        }
        if (messageCooldownSeconds > 0) {
            long timeSinceLastMessage;
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            long cooldownMillis = (long)messageCooldownSeconds * 1000L;
            Long lastMessageTime = messageCooldowns.get(playerId);
            if (lastMessageTime != null && (timeSinceLastMessage = currentTime - lastMessageTime) < cooldownMillis) {
                return false;
            }
            messageCooldowns.put(playerId, currentTime);
        }
        player.sendMessage(message);
        return true;
    }

    public static void clearCooldown(Player player) {
        if (player != null) {
            messageCooldowns.remove(player.getUniqueId());
        }
    }

    public static void clearAllCooldowns() {
        messageCooldowns.clear();
    }

    private static void fixLineWrapping(Path file) {
        block14: {
            try {
                String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                String[] lines = content.split("\n", -1);
                StringBuilder fixed = new StringBuilder();
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    String trimmed = line.trim();
                    if (trimmed.isEmpty() || trimmed.startsWith("#")) {
                        fixed.append(line);
                        if (i >= lines.length - 1) continue;
                        fixed.append("\n");
                        continue;
                    }
                    if (trimmed.contains(":")) {
                        boolean endsWithQuote;
                        int colonIndex = trimmed.indexOf(58);
                        String key = trimmed.substring(0, colonIndex).trim();
                        String valuePart = trimmed.substring(colonIndex + 1).trim();
                        boolean startsWithSingleQuote = valuePart.startsWith("'");
                        boolean startsWithDoubleQuote = valuePart.startsWith("\"");
                        boolean bl = endsWithQuote = valuePart.endsWith("'") || valuePart.endsWith("\"");
                        if ((startsWithSingleQuote || startsWithDoubleQuote) && !endsWithQuote) {
                            int originalIndent;
                            String finalValue;
                            int nextIndent;
                            String nextLine;
                            String nextTrimmed;
                            char quoteChar = startsWithSingleQuote ? (char)'\'' : '\"';
                            StringBuilder fullValue = new StringBuilder();
                            String firstPart = valuePart.substring(1);
                            fullValue.append(firstPart);
                            int baseIndent = line.length() - line.trim().length();
                            boolean foundClosingQuote = false;
                            int j = i + 1;
                            while (j < lines.length && !(nextTrimmed = (nextLine = lines[j]).trim()).isEmpty() && !nextTrimmed.startsWith("#") && (nextIndent = nextLine.length() - nextLine.trim().length()) > baseIndent) {
                                String continuation = nextTrimmed;
                                if (continuation.endsWith("'") || continuation.endsWith("\"")) {
                                    if (continuation.endsWith("'")) {
                                        continuation = continuation.substring(0, continuation.length() - 1);
                                    } else if (continuation.endsWith("\"")) {
                                        continuation = continuation.substring(0, continuation.length() - 1);
                                    }
                                    fullValue.append(" ").append(continuation);
                                    foundClosingQuote = true;
                                    i = j;
                                    break;
                                }
                                fullValue.append(" ").append(continuation);
                                i = j++;
                            }
                            if ((finalValue = fullValue.toString().replaceAll("\\s+", " ").trim()).contains(String.valueOf(quoteChar))) {
                                quoteChar = quoteChar == '\'' ? (char)'\"' : '\'';
                            }
                            int keyIndent = (originalIndent = line.length() - line.trim().length()) <= 1 ? 0 : originalIndent;
                            String indent = " ".repeat(keyIndent);
                            fixed.append(indent).append(key).append(": ").append(quoteChar).append(finalValue).append(quoteChar);
                        } else {
                            fixed.append(line);
                        }
                    } else {
                        fixed.append(line);
                    }
                    if (i >= lines.length - 1) continue;
                    fixed.append("\n");
                }
                Files.write(file, fixed.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception e) {
                if (plugin == null) break block14;
                plugin.getLogger().log(Level.WARNING, "Could not fix line wrapping in messages file: " + e.getMessage(), e);
            }
        }
    }

    public static File getMessagesFile() {
        return messagesFile != null ? messagesFile.toFile() : null;
    }

    public static int getMessageCooldownSeconds() {
        return messageCooldownSeconds;
    }

    static {
        messageCooldowns = new ConcurrentHashMap();
        messageMap = new HashMap<String, String>();
        PROPERTIES = ((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().setNameFormatter(NameFormatters.LOWER_KEBAB_CASE)).header("WorldGuardExtraFlagsPlus Messages Configuration\nThis file is located in the WorldGuard plugin folder\nYou can customize all messages shown to players here\n\nIMPORTANT: Empty String = Disabled Message\nIf you set a message to \"\" (empty string), that message will be disabled\nand no message will be sent to the player. This is useful if you want to\nsilence certain messages while keeping others active.\n\nExample:\n  disable-completely-blocked: \"\"  # This will disable the blocked item message\n\nMessages are cached on plugin load for better performance.\nUse /wg reload or /wgefp reload (or /wgefplus reload or /worldguardextraflagsplus reload) to reload messages without restarting the server.\n\nPlaceholders:\n  {required} - The required level/threshold value\n  {current}  - The player's current level/value\n  {item}     - The item name that was blocked\n\nMessage Cooldown:\n  Prevents message spam by adding a cooldown between messages sent to the same player.\n  Set to 0 to disable cooldown (messages will always be sent).\n  Default: 3 seconds\n")).build();
    }
}

