/*
 * Decompiled with CFR 0.152.
 */
package dev.tins.worldguardextraflagsplus;

import dev.tins.worldguardextraflagsplus.config.PluginConfig;
import dev.tins.worldguardextraflagsplus.configlib.ConfigurationException;
import dev.tins.worldguardextraflagsplus.configlib.NameFormatters;
import dev.tins.worldguardextraflagsplus.configlib.YamlConfigurationProperties;
import dev.tins.worldguardextraflagsplus.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private static JavaPlugin plugin;
    private static PluginConfig config;
    private static Path configFile;
    private static final YamlConfigurationProperties PROPERTIES;

    public static void initialize(JavaPlugin plugin) {
        Config.plugin = plugin;
        File worldGuardDataFolder = plugin.getServer().getPluginManager().getPlugin("WorldGuard").getDataFolder();
        configFile = worldGuardDataFolder.toPath().resolve("config-wgefp.yml");
        Config.reloadConfig();
    }

    public static void reloadConfig() {
        try {
            if (!configFile.getParent().toFile().exists()) {
                configFile.getParent().toFile().mkdirs();
            }
            config = YamlConfigurations.update(configFile, PluginConfig.class, PROPERTIES);
            plugin.getLogger().info("Loaded config from: " + String.valueOf(configFile.toAbsolutePath()));
        }
        catch (ConfigurationException e) {
            Throwable cause = e.getCause();
            Object errorMsg = "Invalid YAML in config-wgefp.yml";
            if (cause != null && cause.getClass().getSimpleName().equals("DuplicateKeyException")) {
                String message = cause.getMessage();
                if (message != null && message.contains("duplicate key")) {
                    int keyStart = message.indexOf("duplicate key");
                    if (keyStart != -1) {
                        String keyPart = message.substring(keyStart);
                        errorMsg = "Duplicate key found in config-wgefp.yml: " + keyPart.split("\n")[0].replace("found duplicate key", "").trim();
                    } else {
                        errorMsg = "Duplicate key found in config-wgefp.yml. Check the file for duplicate entries.";
                    }
                } else {
                    errorMsg = "Duplicate key found in config-wgefp.yml. Check the file for duplicate entries.";
                }
            } else if (cause != null) {
                String causeMsg = cause.getMessage();
                if (causeMsg != null && causeMsg.contains("duplicate key")) {
                    errorMsg = "Duplicate key found in config-wgefp.yml. Check the file for duplicate entries.";
                } else {
                    Object object = errorMsg = causeMsg != null ? causeMsg : cause.getClass().getSimpleName();
                    if (((String)errorMsg).length() > 100) {
                        errorMsg = ((String)errorMsg).substring(0, 100) + "...";
                    }
                }
            }
            plugin.getLogger().severe("CRITICAL: " + (String)errorMsg);
            plugin.getLogger().severe("File location: " + String.valueOf(configFile.toAbsolutePath()));
            plugin.getLogger().severe("Disabling plugin. Please fix the YAML file and restart the server.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            config = new PluginConfig();
        }
        catch (Exception e) {
            Object errorMsg = e.getMessage();
            if (errorMsg != null && ((String)errorMsg).length() > 100) {
                errorMsg = ((String)errorMsg).substring(0, 100) + "...";
            }
            plugin.getLogger().severe("CRITICAL: Failed to load config-wgefp.yml: " + (String)(errorMsg != null ? errorMsg : e.getClass().getSimpleName()));
            plugin.getLogger().severe("File location: " + String.valueOf(configFile.toAbsolutePath()));
            plugin.getLogger().severe("Disabling plugin. Please check the file and restart the server.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            config = new PluginConfig();
        }
    }

    public static boolean isPermitWorkbenchBlockPlacementToo() {
        return config != null ? config.getPermitWorkbenches().isPermitWorkbenchBlockPlacementToo() : false;
    }

    public static boolean isPermitAllIncludesEnderchest() {
        return config != null ? config.getPermitWorkbenches().isPermitAllIncludesEnderchest() : false;
    }

    public static boolean isAutoGiveGodmodeRegionLeft() {
        return config != null ? config.getGodmode().isAutoGiveGodmodeRegionLeft() : false;
    }

    public static File getConfigFile() {
        return configFile != null ? configFile.toFile() : null;
    }

    static {
        PROPERTIES = ((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().setNameFormatter(NameFormatters.LOWER_KEBAB_CASE)).header("WorldGuardExtraFlagsPlus Configuration\nThis file is located in the WorldGuard plugin folder\nYou can customize plugin behavior here\n\nIMPORTANT: This file is reloaded when you use /wg reload or /wgefp reload\n")).build();
    }
}

