/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;

public class AsyncWorldCache {
    private final World world;
    private final Map<Pair<Integer, Integer>, ChunkSnapshot> cache;
    private final Greenhouses addon;

    public AsyncWorldCache(Greenhouses addon, World world) {
        this.world = world;
        this.cache = new HashMap<Pair<Integer, Integer>, ChunkSnapshot>();
        this.addon = addon;
    }

    public World.Environment getEnvironment() {
        return this.world.getEnvironment();
    }

    public int getMaxHeight() {
        return this.world.getMaxHeight();
    }

    private CompletableFuture<ChunkSnapshot> getAChunk(int x, int z) {
        CompletableFuture<ChunkSnapshot> r = new CompletableFuture<ChunkSnapshot>();
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> Util.getChunkAtAsync((World)this.world, (int)x, (int)z).thenAccept(chunk -> r.complete(chunk.getChunkSnapshot())));
        return r;
    }

    private @Nullable ChunkSnapshot getSnap(int x, int z) throws InterruptedException, ExecutionException {
        Pair key = new Pair((Object)(x >> 4), (Object)(z >> 4));
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        ChunkSnapshot cs = this.getAChunk((Integer)key.x, (Integer)key.z).get();
        this.cache.put((Pair<Integer, Integer>)key, cs);
        return cs;
    }

    public Material getBlockType(int x, int y, int z) {
        int xx = x >= 0 ? x % 16 : (16 + x % 16) % 16;
        int zz = z >= 0 ? z % 16 : (16 + z % 16) % 16;
        try {
            return Objects.requireNonNull(this.getSnap(x, z)).getBlockType(xx, y, zz);
        }
        catch (InterruptedException | ExecutionException e) {
            this.addon.logError("Chunk could not be obtained async! " + String.valueOf(e));
            Thread.currentThread().interrupt();
            return Material.AIR;
        }
    }

    public Material getBlockType(Vector v) {
        return this.getBlockType(v.getBlockX(), v.getBlockY(), v.getBlockZ());
    }

    public boolean isEmpty(Vector vector) {
        return this.getBlockType(vector).equals((Object)Material.AIR);
    }
}

