/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.ui.user;

import java.util.List;
import org.bukkit.World;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.data.Greenhouse;

class RemoveCommand
extends CompositeCommand {
    public RemoveCommand(CompositeCommand parent) {
        super(parent, "remove", new String[0]);
    }

    public void setup() {
        this.setPermission("greenhouses.player");
        this.setOnlyPlayer(true);
        this.setDescription("greenhouses.commands.user.remove.description");
    }

    public boolean execute(User user, String label, List<String> args) {
        if (!Util.getWorld((World)user.getWorld()).equals((Object)this.getWorld())) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        if (!this.getIslands().getIslandAt(user.getLocation()).map(i -> i.isAllowed(user, Greenhouses.GREENHOUSES)).orElse(false).booleanValue()) {
            user.sendMessage("greenhouses.errors.no-rank", new String[0]);
            return false;
        }
        Greenhouses addon = (Greenhouses)this.getAddon();
        if (!addon.getManager().getMap().getGreenhouse(user.getLocation()).map(gh -> {
            user.sendMessage("general.success", new String[0]);
            addon.getManager().removeGreenhouse((Greenhouse)gh);
            return true;
        }).orElse(false).booleanValue()) {
            user.sendMessage("greenhouses.errors.not-inside", new String[0]);
            return false;
        }
        return true;
    }
}

