/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.ui.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.managers.GreenhouseManager;
import world.bentobox.greenhouses.ui.panel.Panel;

class MakeCommand
extends CompositeCommand {
    public MakeCommand(CompositeCommand parent) {
        super(parent, "make", new String[0]);
    }

    public void setup() {
        this.setPermission("greenhouses.player");
        this.setOnlyPlayer(true);
        this.setParametersHelp("greenhouses.commands.user.make.parameters");
        this.setDescription("greenhouses.commands.user.make.description");
    }

    public boolean execute(User user, String label, List<String> args) {
        if (!Util.getWorld((World)user.getWorld()).equals((Object)this.getWorld())) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        if (args.isEmpty()) {
            new Panel((Greenhouses)this.getAddon()).showPanel(user);
            return true;
        }
        BiomeRecipe br = this.getRecipe(user, args.get(0));
        if (br == null) {
            user.sendMessage("greenhouses.commands.user.make.unknown-recipe", new String[0]);
            user.sendMessage("greenhouses.commands.user.make.try-these", new String[0]);
            this.getRecipes(user).forEach((k, v) -> user.sendMessage("greenhouses.commands.user.make.recipe-format", new String[]{"[name]", v.getName()}));
            return false;
        }
        return this.makeGreenhouse(user, br);
    }

    private BiomeRecipe getRecipe(User user, String arg) {
        return this.getRecipes(user).get(arg);
    }

    private Map<String, BiomeRecipe> getRecipes(User user) {
        return ((Greenhouses)this.getAddon()).getRecipes().getBiomeRecipes().stream().filter(br -> user.hasPermission(br.getPermission())).collect(Collectors.toMap(BiomeRecipe::getName, br -> br));
    }

    private boolean makeGreenhouse(User user, BiomeRecipe br) {
        if (!this.getIslands().getIslandAt(user.getLocation()).map(i -> i.isAllowed(user, Greenhouses.GREENHOUSES)).orElse(false).booleanValue()) {
            user.sendMessage("greenhouses.errors.no-rank", new String[0]);
            return false;
        }
        Location location = user.getLocation().add(new Vector(0, 1, 0));
        if (((Greenhouses)this.getAddon()).getManager().getMap().getGreenhouse(location).isPresent()) {
            user.sendMessage("greenhouses.commands.user.make.error.already", new String[0]);
            return false;
        }
        ((Greenhouses)this.getAddon()).getManager().tryToMakeGreenhouse(location, br).thenAccept(result -> this.informUser(user, br, (GreenhouseManager.GhResult)result));
        return true;
    }

    private boolean informUser(User user, BiomeRecipe br, GreenhouseManager.GhResult result) {
        if (result.getResults().contains((Object)GreenhouseManager.GreenhouseResult.SUCCESS)) {
            user.sendMessage("greenhouses.commands.user.make.success", new String[]{"[biome]", result.getFinder().getGh().getBiomeRecipe().getFriendlyName()});
            return true;
        }
        result.getResults().forEach(r -> user.sendMessage("greenhouses.commands.user.make.error." + r.name(), new String[0]));
        if (!result.getFinder().getRedGlass().isEmpty()) {
            result.getFinder().getRedGlass().forEach(rg -> user.getPlayer().sendBlockChange(rg.toLocation(user.getWorld()), Material.RED_STAINED_GLASS.createBlockData()));
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> result.getFinder().getRedGlass().stream().map(v -> v.toLocation(user.getWorld())).forEach(rg -> user.getPlayer().sendBlockChange(rg, rg.getBlock().getBlockData())), 120L);
        }
        if (br != null && result.getResults().contains((Object)GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_BLOCKS)) {
            result.getFinder().getGh().getMissingBlocks().forEach((k, v) -> user.sendMessage("greenhouses.commands.user.make.missing-blocks", new String[]{"[material]", Util.prettifyText((String)k.toString()), "[number]", String.valueOf(v)}));
        }
        return false;
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(new ArrayList<String>(this.getRecipes(user).keySet()));
    }
}

