/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.ui.panel;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.managers.GreenhouseManager;

public class PanelClick
implements PanelItem.ClickHandler {
    private final Greenhouses addon;
    private final BiomeRecipe br;

    public PanelClick(Greenhouses addon, BiomeRecipe br) {
        this.addon = addon;
        this.br = br;
    }

    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        if (user.hasPermission(this.br.getPermission())) {
            user.closeInventory();
            this.makeGreenhouse(user, this.br);
        }
        return true;
    }

    private boolean makeGreenhouse(User user, BiomeRecipe br) {
        if (!this.addon.getIslands().getIslandAt(user.getLocation()).map(i -> i.isAllowed(user, Greenhouses.GREENHOUSES)).orElse(false).booleanValue()) {
            user.sendMessage("greenhouses.errors.no-rank", new String[0]);
            return false;
        }
        Location location = user.getLocation().add(new Vector(0, 1, 0));
        if (this.addon.getManager().getMap().getGreenhouse(location).isPresent()) {
            user.sendMessage("greenhouses.commands.user.make.error.already", new String[0]);
            return false;
        }
        this.addon.getManager().tryToMakeGreenhouse(location, br).thenAccept(r -> this.processResult(user, (GreenhouseManager.GhResult)r));
        return true;
    }

    void processResult(User user, GreenhouseManager.GhResult result) {
        if (result.getResults().contains((Object)GreenhouseManager.GreenhouseResult.SUCCESS)) {
            user.sendMessage("greenhouses.commands.user.make.success", new String[]{"[biome]", result.getFinder().getGh().getBiomeRecipe().getFriendlyName()});
            return;
        }
        result.getResults().forEach(r -> user.sendMessage("greenhouses.commands.user.make.error." + r.name(), new String[0]));
        if (!result.getFinder().getRedGlass().isEmpty()) {
            result.getFinder().getRedGlass().stream().map(v -> v.toLocation(user.getWorld())).forEach(rg -> user.getPlayer().sendBlockChange(rg, Material.RED_STAINED_GLASS.createBlockData()));
            Bukkit.getScheduler().runTaskLater((Plugin)this.addon.getPlugin(), () -> result.getFinder().getRedGlass().stream().map(v -> v.toLocation(user.getWorld())).forEach(rg -> user.getPlayer().sendBlockChange(rg, rg.getBlock().getBlockData())), 120L);
        }
        if (result.getResults().contains((Object)GreenhouseManager.GreenhouseResult.FAIL_INSUFFICIENT_BLOCKS)) {
            result.getFinder().getGh().getMissingBlocks().forEach((k, v) -> user.sendMessage("greenhouses.commands.user.make.missing-blocks", new String[]{"[material]", Util.prettifyText((String)k.toString()), "[number]", String.valueOf(v)}));
        }
    }
}

