/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.ui.panel;

import java.util.ArrayList;
import java.util.List;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;
import world.bentobox.greenhouses.ui.panel.PanelClick;

public class Panel {
    private static final String COVERAGE = "[coverage]";
    private final Greenhouses addon;

    public Panel(Greenhouses addon) {
        this.addon = addon;
    }

    public void showPanel(User user) {
        PanelBuilder pb = new PanelBuilder().name(user.getTranslation("greenhouses.general.greenhouses", new String[0]));
        for (BiomeRecipe br : this.addon.getRecipes().getBiomeRecipes()) {
            if (!user.hasPermission(br.getPermission())) continue;
            pb.item(new PanelItemBuilder().name(br.getFriendlyName()).icon(br.getIcon()).description(this.getDescription(user, br)).clickHandler((PanelItem.ClickHandler)new PanelClick(this.addon, br)).build());
        }
        pb.user(user).build();
    }

    private List<String> getDescription(User user, BiomeRecipe br) {
        ArrayList<String> d = new ArrayList<String>();
        d.add(user.getTranslation("greenhouses.recipe.title", new String[]{"[biome]", Util.prettifyText((String)br.getBiome().getKey().getKey())}));
        if (!br.getRecipeBlocks().isEmpty()) {
            d.add(user.getTranslation("greenhouses.recipe.minimumblockstitle", new String[0]));
            br.getRecipeBlocks().forEach(b -> d.add(user.getTranslation("greenhouses.recipe.blockscolor", new String[0]) + b));
        }
        if (br.getWaterCoverage() > 0) {
            d.add(user.getTranslation("greenhouses.recipe.watermustbe", new String[]{COVERAGE, String.valueOf(br.getWaterCoverage())}));
        }
        if (br.getLavaCoverage() > 0) {
            d.add(user.getTranslation("greenhouses.recipe.lavamustbe", new String[]{COVERAGE, String.valueOf(br.getLavaCoverage())}));
        }
        if (br.getIceCoverage() > 0) {
            d.add(user.getTranslation("greenhouses.recipe.icemustbe", new String[]{COVERAGE, String.valueOf(br.getIceCoverage())}));
        }
        if (br.getRecipeBlocks().isEmpty()) {
            d.add(user.getTranslation("greenhouses.recipe.nootherblocks", new String[0]));
        }
        return d;
    }
}

