/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.greenhouses.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.util.OldEnum;
import world.bentobox.bentobox.util.Util;
import world.bentobox.greenhouses.Greenhouses;
import world.bentobox.greenhouses.greenhouse.BiomeRecipe;

public class RecipeManager {
    private static final int MAXIMUM_INVENTORY_SIZE = 49;
    private final Greenhouses addon;
    private static final List<BiomeRecipe> biomeRecipes = new ArrayList<BiomeRecipe>();
    private static final String COULD_NOT_PARSE = "Could not parse ";

    public RecipeManager(Greenhouses addon) {
        this.addon = addon;
        try {
            this.loadBiomeRecipes();
        }
        catch (Exception e) {
            addon.logError(e.getMessage());
        }
    }

    public static Optional<BiomeRecipe> getBiomeRecipies(String name) {
        return biomeRecipes.stream().filter(r -> r.getName().equals(name)).findFirst();
    }

    private void loadBiomeRecipes() throws IOException, InvalidConfigurationException {
        biomeRecipes.clear();
        YamlConfiguration biomeConfig = new YamlConfiguration();
        File biomeFile = new File(this.addon.getDataFolder(), "biomes.yml");
        if (!biomeFile.exists()) {
            this.addon.logError("No biomes.yml file!");
            this.addon.saveResource("biomes.yml", true);
        }
        biomeConfig.load(biomeFile);
        if (!biomeConfig.isConfigurationSection("biomes")) {
            this.addon.logError("biomes.yml file is missing, empty or corrupted. Delete and reload plugin again!");
            return;
        }
        ConfigurationSection biomeSection = biomeConfig.getConfigurationSection("biomes");
        assert (biomeSection != null);
        for (String type : biomeSection.getValues(false).keySet()) {
            this.processEntries(type, biomeSection);
            if (biomeRecipes.size() != 49) continue;
            this.addon.logWarning("Cannot load any more biome recipies - limit is 49");
            break;
        }
        this.addon.log("Loaded " + biomeRecipes.size() + " biome recipes.");
    }

    private void processEntries(String biomeType, ConfigurationSection biomeSection) {
        try {
            ConfigurationSection biomeRecipeConfig = biomeSection.getConfigurationSection(biomeType);
            assert (biomeRecipeConfig != null);
            Biome thisBiome = this.loadBiome(biomeType, biomeRecipeConfig);
            if (thisBiome == null) {
                return;
            }
            int priority = biomeRecipeConfig.getInt("priority", 0);
            BiomeRecipe biomeRecipe = this.getBiomeRecipe(biomeRecipeConfig, biomeType, thisBiome, priority);
            ConfigurationSection reqContents = biomeRecipeConfig.getConfigurationSection("contents");
            if (reqContents != null) {
                for (String rq : reqContents.getKeys(false)) {
                    this.parseReqBlock(biomeRecipe, rq, reqContents);
                }
            }
            this.loadPlants(biomeRecipeConfig, biomeRecipe);
            this.loadMobs(biomeRecipeConfig, biomeRecipe);
            this.loadBlockConversions(biomeRecipeConfig, biomeRecipe);
            biomeRecipes.add(biomeRecipe);
        }
        catch (Exception e) {
            this.addon.logError("Problem loading biome recipe - skipping! " + e.getMessage());
            StringBuilder validBiomes = new StringBuilder();
            Registry.BIOME.forEach(biome -> validBiomes.append(" ").append(biome.getKey().getKey()));
            this.addon.logError("Valid biomes are " + String.valueOf(validBiomes));
        }
    }

    private Biome loadBiome(String biomeType, ConfigurationSection biomeRecipeConfig) {
        if (!biomeRecipeConfig.contains("biome")) {
            this.addon.logError("No biome defined in the biome reciepe " + biomeType + ". Skipping...");
            return null;
        }
        String name = Objects.requireNonNull(biomeRecipeConfig.getString("biome")).toUpperCase(Locale.ENGLISH);
        Biome b = Biome.valueOf((String)name);
        if (b != null) {
            return b;
        }
        if (name.equals("NETHER") || name.equals("NETHER_WASTES")) {
            return Biome.NETHER_WASTES;
        }
        this.addon.logError("Biome " + name + " is invalid! Use one of these...");
        this.addon.logError(Arrays.stream(Biome.values()).map(OldEnum::name).collect(Collectors.joining(",")));
        return null;
    }

    private BiomeRecipe getBiomeRecipe(ConfigurationSection biomeRecipeConfig, String biomeType, Biome thisBiome, int priority) {
        BiomeRecipe b = new BiomeRecipe(this.addon, thisBiome, priority);
        b.setName(biomeType);
        if (this.addon.getSettings().isStartupLog()) {
            this.addon.log("Adding biome recipe for " + biomeType);
        }
        b.setPermission(biomeRecipeConfig.getString("permission", ""));
        b.setIcon(Material.valueOf((String)biomeRecipeConfig.getString("icon", "SAPLING")));
        b.setFriendlyName(ChatColor.translateAlternateColorCodes((char)'&', (String)biomeRecipeConfig.getString("friendlyname", Util.prettifyText((String)biomeType))));
        b.setWatercoverage(biomeRecipeConfig.getInt("watercoverage", -1));
        b.setLavacoverage(biomeRecipeConfig.getInt("lavacoverage", -1));
        b.setIcecoverage(biomeRecipeConfig.getInt("icecoverage", -1));
        b.setMobLimit(biomeRecipeConfig.getInt("moblimit", 9));
        b.setMaxMob(biomeRecipeConfig.getInt("maxmobs", -1));
        return b;
    }

    private void loadPlants(ConfigurationSection biomeRecipeConfig, BiomeRecipe b) {
        ConfigurationSection temp = biomeRecipeConfig.getConfigurationSection("plants");
        if (temp != null) {
            HashMap plants = (HashMap)temp.getValues(false);
            for (Map.Entry s : plants.entrySet()) {
                Material plantMaterial = Material.valueOf((String)((String)s.getKey()));
                String[] split = ((String)s.getValue()).split(":");
                double plantProbability = Double.parseDouble(split[0]);
                Material plantGrowOn = Material.valueOf((String)split[1]);
                b.addPlants(plantMaterial, plantProbability, plantGrowOn);
            }
        }
    }

    private void loadBlockConversions(ConfigurationSection biomeRecipeConfig, BiomeRecipe b) {
        ConfigurationSection conversionSec = biomeRecipeConfig.getConfigurationSection("conversions");
        if (conversionSec != null) {
            for (String oldMat : conversionSec.getKeys(false)) {
                this.parseConversions(oldMat, conversionSec, b);
            }
        }
        for (String oldMat : biomeRecipeConfig.getStringList("conversion-list")) {
            this.parseConversionList(oldMat, b);
        }
    }

    private void parseConversionList(String oldMat, BiomeRecipe b) {
        try {
            String[] split = oldMat.split(":");
            Material oldMaterial = Material.valueOf((String)split[0].toUpperCase());
            double convChance = Double.parseDouble(split[1]);
            Material newMaterial = Material.valueOf((String)split[2]);
            Material localMaterial = null;
            if (split.length > 3) {
                localMaterial = Material.valueOf((String)split[3]);
            }
            b.addConvBlocks(oldMaterial, newMaterial, convChance, localMaterial);
        }
        catch (Exception e) {
            this.addon.logError(COULD_NOT_PARSE + oldMat);
        }
    }

    private void parseConversions(String oldMat, ConfigurationSection conversionSec, BiomeRecipe b) {
        try {
            Material oldMaterial = Material.valueOf((String)oldMat.toUpperCase(Locale.ENGLISH));
            String conversions = conversionSec.getString(oldMat);
            if (!Objects.requireNonNull(conversions).isEmpty()) {
                String[] split = conversions.split(":");
                double convChance = Double.parseDouble(split[0]);
                Material newMaterial = Material.valueOf((String)split[1]);
                Material localMaterial = null;
                if (split.length > 2) {
                    localMaterial = Material.valueOf((String)split[2]);
                }
                b.addConvBlocks(oldMaterial, newMaterial, convChance, localMaterial);
            }
        }
        catch (Exception e) {
            this.addon.logError(COULD_NOT_PARSE + oldMat);
        }
    }

    private void loadMobs(ConfigurationSection biomeRecipeConfig, BiomeRecipe b) {
        ConfigurationSection temp = biomeRecipeConfig.getConfigurationSection("mobs");
        if (temp != null) {
            temp.getValues(false).entrySet().forEach(s -> this.parseMob((Map.Entry<String, Object>)s, b));
        }
    }

    private void parseMob(Map.Entry<String, Object> s, BiomeRecipe b) {
        try {
            EntityType mobType;
            String mobName = s.getKey().toUpperCase(Locale.ENGLISH);
            String[] mobData = mobName.split("#");
            Consumer<Entity> customizer = null;
            if (mobData.length == 1) {
                mobType = EntityType.valueOf((String)mobName);
            } else {
                mobType = EntityType.valueOf((String)mobData[0].toUpperCase(Locale.ENGLISH));
                customizer = this.parseCustomMobData(mobType, mobData[1]);
            }
            String[] split = ((String)s.getValue()).split(":");
            double mobProbability = Double.parseDouble(split[0]);
            Material mobSpawnOn = Material.valueOf((String)split[1]);
            b.addMobs(mobType, mobProbability, mobSpawnOn, customizer);
        }
        catch (Exception e) {
            this.addon.logError(COULD_NOT_PARSE + s.getKey());
        }
    }

    private Consumer<Entity> parseCustomMobData(EntityType mobType, String customData) {
        String UNKNOWN_MOB_DATA = "Unknown mob data: %s.";
        switch (mobType) {
            case CREEPER: {
                if (customData.equals("CHARGED")) {
                    return entity -> ((Creeper)entity).setPowered(true);
                }
                this.addon.logError(String.format(UNKNOWN_MOB_DATA, customData));
                return null;
            }
            case CHICKEN: {
                if (customData.equals("JOCKEY")) {
                    return entity -> {
                        Zombie zombie = (Zombie)entity.getWorld().spawnEntity(entity.getLocation(), EntityType.ZOMBIE);
                        zombie.setBaby();
                        entity.addPassenger((Entity)zombie);
                    };
                }
                this.addon.logError(String.format(UNKNOWN_MOB_DATA, customData));
                return null;
            }
            case SHEEP: {
                if (customData.equals("RAINBOW")) {
                    return entity -> entity.setCustomName("jeb_");
                }
                this.addon.logError(String.format(UNKNOWN_MOB_DATA, customData));
                return null;
            }
            case WOLF: {
                switch (customData) {
                    case "ASHEN": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.ASHEN);
                    }
                    case "BLACK": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.BLACK);
                    }
                    case "CHESTNUT": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.CHESTNUT);
                    }
                    case "PALE": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.PALE);
                    }
                    case "RUSTY": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.RUSTY);
                    }
                    case "SNOWY": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.SNOWY);
                    }
                    case "SPOTTED": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.SPOTTED);
                    }
                    case "STRIPED": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.STRIPED);
                    }
                    case "WOODS": {
                        return entity -> ((Wolf)entity).setVariant(Wolf.Variant.WOODS);
                    }
                }
                this.addon.logError(String.format(UNKNOWN_MOB_DATA, customData));
                return null;
            }
        }
        this.addon.logError("Custom mob data for " + String.valueOf(mobType) + " is not supported.");
        return null;
    }

    private void parseReqBlock(BiomeRecipe b, String rq, ConfigurationSection reqContents) {
        try {
            b.addReqBlocks(Material.valueOf((String)rq.toUpperCase(Locale.ENGLISH)), reqContents.getInt(rq));
        }
        catch (Exception e) {
            this.addon.logError("Could not parse required block " + rq);
        }
    }

    public List<BiomeRecipe> getBiomeRecipes() {
        return biomeRecipes;
    }
}

